# Sistema de Controle e Administração Financeira de Clínicas

Um sistema completo desenvolvido em PHP para gestão administrativa e financeira de clínicas médicas e psicológicas.

## 📋 Funcionalidades

### 🏥 Gestão de Clínicas
- Cadastro completo de clínicas com documentação fiscal
- Controle de validade de documentos
- Upload de arquivos (PDF até 5MB)
- Documentos suportados:
  - Contrato Social, CNPJ, Certidões Negativas
  - Licenças e Alvarás
  - Certificados de Calibração
  - E muito mais...

### 👨‍⚕️ Gestão de Profissionais
- Cadastro de médicos e psicólogos
- Controle de registros profissionais
- Gestão salarial
- Upload de documentos pessoais

### 📅 Agenda de Atendimentos
- Calendário visual interativo
- Agendamento de consultas
- Controle de presença/falta
- Integração com WhatsApp
- Notificações automáticas

### 💰 Controle Financeiro
- Fechamento diário automático
- Relatórios por forma de pagamento
- Controle de despesas
- Cálculo de comissões
- Análise de performance

### 📊 Relatórios Avançados
- Agendamentos por período
- Pacientes faltantes
- Relatórios financeiros
- Gráficos interativos
- Exportação para Excel/PDF

### 👥 Sistema de Usuários
- Três níveis de acesso:
  - **Administrador**: Acesso total
  - **Gerente**: Gestão de clínica específica
  - **Secretária**: Operações básicas
- Autenticação segura
- Reset de senhas
- Controle de sessões

## 🛠️ Tecnologias Utilizadas

- **Backend**: PHP 7.4+
- **Frontend**: HTML5, CSS3, JavaScript
- **Framework CSS**: Bootstrap 5.3
- **Banco de Dados**: MySQL 8.0+
- **Gráficos**: Chart.js
- **Ícones**: Font Awesome 6.4

## 📦 Requisitos do Sistema

### Servidor Web
- Apache 2.4+ ou Nginx 1.18+
- PHP 7.4 ou superior
- MySQL 8.0 ou superior
- Extensões PHP necessárias:
  - PDO
  - PDO_MySQL
  - mbstring
  - fileinfo
  - json

### Navegador
- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

## 🚀 Instalação

### 1. Download e Configuração
```bash
# Clone ou baixe os arquivos do sistema
# Coloque na pasta do seu servidor web (htdocs, www, etc.)
```

### 2. Configuração do Banco de Dados
```sql
-- Crie um banco de dados MySQL
CREATE DATABASE sistema_clinicas CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Crie um usuário (opcional)
CREATE USER 'clinicas_user'@'localhost' IDENTIFIED BY 'sua_senha_segura';
GRANT ALL PRIVILEGES ON sistema_clinicas.* TO 'clinicas_user'@'localhost';
FLUSH PRIVILEGES;
```

### 3. Instalação Automática
1. Acesse `http://seu-servidor/sistema_clinicas/install.php`
2. Siga o assistente de instalação:
   - Configure a conexão com o banco
   - Crie as tabelas automaticamente
   - Configure o usuário administrador
   - Finalize a instalação

### 4. Configuração de Segurança
```bash
# Após a instalação, delete o arquivo de instalação
rm install.php

# Configure permissões adequadas
chmod 755 assets/
chmod 755 uploads/
chmod 644 config/*.php
```

## 📁 Estrutura do Projeto

```
sistema_clinicas/
├── assets/                 # Arquivos estáticos (CSS, JS, imagens)
│   ├── css/
│   ├── js/
│   └── images/
├── config/                 # Configurações do sistema
│   ├── config.php
│   ├── database.php
│   └── installed.lock
├── includes/               # Arquivos incluídos
│   ├── header.php
│   ├── footer.php
│   └── functions.php
├── modules/                # Módulos do sistema
│   ├── agendamentos/
│   ├── atendimentos/
│   ├── clinicas/
│   ├── financeiro/
│   ├── pacientes/
│   ├── profissionais/
│   ├── relatorios/
│   ├── tipos_exames/
│   └── usuarios/
├── uploads/                # Arquivos enviados
├── database_schema.sql     # Estrutura do banco
├── install.php            # Instalador (deletar após uso)
├── login.php              # Página de login
├── dashboard.php          # Dashboard principal
└── README.md              # Este arquivo
```

## 🔧 Configuração

### Configurações Principais
Edite o arquivo `config/config.php` para ajustar:

```php
// Configurações gerais
define('SITE_NAME', 'Sistema de Clínicas');
define('SITE_URL', 'http://localhost/sistema_clinicas');

// Upload de arquivos
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB
define('UPLOAD_PATH', 'uploads/');

// Configurações de sessão
define('SESSION_TIMEOUT', 3600); // 1 hora
```

### Configuração de Email (Opcional)
Para notificações por email, configure:

```php
// Configurações de email
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USER', 'seu-email@gmail.com');
define('SMTP_PASS', 'sua-senha-app');
```

## 👤 Usuários Padrão

Após a instalação, será criado um usuário administrador:

- **Email**: admin@sistema.com
- **Senha**: admin123

⚠️ **Importante**: Altere a senha imediatamente após o primeiro login!

## 📖 Manual de Uso

### Para Administradores
1. **Gestão de Clínicas**: Cadastre e gerencie todas as clínicas
2. **Usuários**: Crie gerentes e secretárias
3. **Relatórios**: Acesse relatórios consolidados
4. **Configurações**: Gerencie tipos de exames e valores

### Para Gerentes
1. **Gestão da Clínica**: Administre sua clínica específica
2. **Profissionais**: Cadastre médicos e psicólogos
3. **Secretárias**: Crie usuários secretárias
4. **Financeiro**: Acesse relatórios financeiros

### Para Secretárias
1. **Agenda**: Gerencie agendamentos diários
2. **Pacientes**: Cadastre e atualize dados
3. **Atendimentos**: Registre presenças e atendimentos
4. **Relatórios**: Consulte relatórios básicos

## 🔒 Segurança

### Medidas Implementadas
- Senhas criptografadas com `password_hash()`
- Proteção contra SQL Injection (PDO)
- Validação de entrada de dados
- Controle de sessões
- Verificação de permissões
- Upload seguro de arquivos

### Recomendações
1. Use HTTPS em produção
2. Mantenha o PHP atualizado
3. Faça backups regulares
4. Use senhas fortes
5. Monitore logs de acesso

## 🔄 Backup e Restauração

### Backup do Banco de Dados
```bash
# Backup completo
mysqldump -u usuario -p sistema_clinicas > backup_$(date +%Y%m%d).sql

# Backup apenas dados
mysqldump -u usuario -p --no-create-info sistema_clinicas > dados_$(date +%Y%m%d).sql
```

### Backup de Arquivos
```bash
# Backup da pasta uploads
tar -czf uploads_backup_$(date +%Y%m%d).tar.gz uploads/

# Backup completo do sistema
tar -czf sistema_completo_$(date +%Y%m%d).tar.gz sistema_clinicas/
```

### Restauração
```bash
# Restaurar banco de dados
mysql -u usuario -p sistema_clinicas < backup_20231201.sql

# Restaurar arquivos
tar -xzf uploads_backup_20231201.tar.gz
```

## 🐛 Solução de Problemas

### Problemas Comuns

#### Erro de Conexão com Banco
```
Solução: Verifique as configurações em config/database.php
- Host correto
- Usuário e senha válidos
- Banco de dados existe
```

#### Erro de Upload de Arquivos
```
Solução: Verifique permissões da pasta uploads/
chmod 755 uploads/
```

#### Sessão Expirada
```
Solução: Ajuste o timeout em config/config.php
define('SESSION_TIMEOUT', 7200); // 2 horas
```

#### Erro 500 - Internal Server Error
```
Solução: Verifique os logs do servidor
- Erro de sintaxe PHP
- Permissões de arquivo
- Configurações do servidor
```

## 📞 Suporte

### Logs do Sistema
Os logs são armazenados em:
- Logs de erro: `logs/error.log`
- Logs de acesso: `logs/access.log`
- Logs de debug: `logs/debug.log`

### Informações de Debug
Para ativar o modo debug, edite `config/config.php`:
```php
define('DEBUG_MODE', true);
define('DISPLAY_ERRORS', true);
```

## 🔄 Atualizações

### Verificar Versão
A versão atual pode ser verificada em `config/config.php`:
```php
define('SYSTEM_VERSION', '1.0.0');
```

### Processo de Atualização
1. Faça backup completo
2. Baixe a nova versão
3. Execute scripts de migração (se houver)
4. Teste todas as funcionalidades

## 📄 Licença

Este sistema foi desenvolvido para uso interno de clínicas médicas e psicológicas.

## 🤝 Contribuição

Para melhorias e correções:
1. Documente o problema ou sugestão
2. Teste em ambiente de desenvolvimento
3. Mantenha compatibilidade com versões anteriores

## 📊 Estatísticas do Projeto

- **Linhas de código**: ~15.000
- **Arquivos PHP**: 45+
- **Tabelas do banco**: 12
- **Funcionalidades**: 50+
- **Tempo de desenvolvimento**: 40+ horas

---

**Desenvolvido com ❤️ para facilitar a gestão de clínicas médicas e psicológicas.**
