<?php
/**
 * Configuração do Banco de Dados
 * Sistema de Controle e Administração Financeira de Clínicas
 */

// Configurações do banco de dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'sistema_clinicas');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Classe para conexão com o banco de dados
class Database {
    private $host = DB_HOST;
    private $db_name = DB_NAME;
    private $username = DB_USER;
    private $password = DB_PASS;
    private $charset = DB_CHARSET;
    public $conn;

    public function getConnection() {
        $this->conn = null;
        
        try {
            $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=" . $this->charset;
            $this->conn = new PDO($dsn, $this->username, $this->password);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch(PDOException $exception) {
            echo "Erro de conexão: " . $exception->getMessage();
        }
        
        return $this->conn;
    }
}

// Função para obter conexão global
function getDBConnection() {
    $database = new Database();
    return $database->getConnection();
}
?>
