<?php
require_once 'config/config.php';
require_once 'modules/clinicas/Clinica.php';
require_once 'modules/profissionais/Profissional.php';
require_once 'modules/pacientes/Paciente.php';

verificarLogin();

$page_title = 'Dashboard';

// Instanciar classes para obter estatísticas
$clinica = new Clinica();
$profissional = new Profissional();
$paciente = new Paciente();

// Obter estatísticas gerais
$total_clinicas = $clinica->contarTotal();
$total_profissionais = $profissional->contarTotal();
$total_pacientes = $paciente->contarTotal();

// Obter estatísticas de profissionais por tipo
$profissionais_por_tipo = $profissional->contarPorTipo();
$total_medicos = 0;
$total_psicologos = 0;

foreach ($profissionais_por_tipo as $tipo) {
    if ($tipo['tipo_registro'] === 'Medico') {
        $total_medicos = $tipo['total'];
    } elseif ($tipo['tipo_registro'] === 'Psicologo') {
        $total_psicologos = $tipo['total'];
    }
}

// Obter agendamentos de hoje (simulado por enquanto)
$agendamentos_hoje = 0; // Será implementado na próxima fase

include 'includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-tachometer-alt me-2 text-primary"></i>
                Dashboard
            </h1>
            <div class="text-muted">
                <i class="fas fa-calendar me-1"></i>
                <?php echo date('d/m/Y H:i'); ?>
            </div>
        </div>
    </div>
</div>

<!-- Cards de Estatísticas -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Clínicas Cadastradas
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?php echo $total_clinicas; ?>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-building fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Profissionais
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?php echo $total_profissionais; ?>
                        </div>
                        <div class="text-xs text-muted">
                            <?php echo $total_medicos; ?> Médicos | <?php echo $total_psicologos; ?> Psicólogos
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-user-md fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Pacientes Cadastrados
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?php echo $total_pacientes; ?>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Agendamentos Hoje
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?php echo $agendamentos_hoje; ?>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Ações Rápidas -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    Ações Rápidas
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <a href="modules/agendamentos/novo.php" class="btn btn-outline-primary w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                            <i class="fas fa-plus fa-2x mb-2"></i>
                            <span>Novo Agendamento</span>
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="modules/agendamentos/agenda.php" class="btn btn-outline-success w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                            <i class="fas fa-calendar fa-2x mb-2"></i>
                            <span>Ver Agenda</span>
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="modules/agendamentos/atendimentos_dia.php" class="btn btn-outline-info w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                            <i class="fas fa-check fa-2x mb-2"></i>
                            <span>Atendimentos Hoje</span>
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="modules/financeiro/fechamento.php" class="btn btn-outline-warning w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                            <i class="fas fa-calculator fa-2x mb-2"></i>
                            <span>Fechamento</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Informações Importantes -->
<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Bem-vindo ao Sistema
                </h5>
            </div>
            <div class="card-body">
                <p class="card-text">
                    Este é o <strong>Sistema de Controle e Administração Financeira de Clínicas</strong>. 
                    Aqui você pode gerenciar todos os aspectos da sua clínica de forma integrada.
                </p>
                <h6>Principais funcionalidades:</h6>
                <ul class="list-unstyled">
                    <li><i class="fas fa-check text-success me-2"></i>Cadastro de clínicas e documentos</li>
                    <li><i class="fas fa-check text-success me-2"></i>Gestão de profissionais</li>
                    <li><i class="fas fa-check text-success me-2"></i>Agenda de atendimentos</li>
                    <li><i class="fas fa-check text-success me-2"></i>Controle financeiro</li>
                    <li><i class="fas fa-check text-success me-2"></i>Relatórios e consultas</li>
                </ul>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 mb-4">
        <div class="card shadow">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    Alertas e Notificações
                </h5>
            </div>
            <div class="card-body">
                <div class="alert alert-info" role="alert">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Sistema em desenvolvimento!</strong><br>
                    Algumas funcionalidades ainda estão sendo implementadas.
                </div>
                
                <div class="alert alert-success" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <strong>Módulos disponíveis:</strong><br>
                    Cadastros básicos e estrutura principal.
                </div>
                
                <div class="alert alert-warning" role="alert">
                    <i class="fas fa-clock me-2"></i>
                    <strong>Em breve:</strong><br>
                    Agenda completa e relatórios financeiros.
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}

.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}

.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}

.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}

.text-xs {
    font-size: 0.7rem;
}

.text-gray-300 {
    color: #dddfeb !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.card {
    transition: all 0.3s;
}

.card:hover {
    transform: translateY(-5px);
}

.btn:hover {
    transform: translateY(-2px);
}
</style>

<?php include 'includes/footer.php'; ?>
