<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Sistema de Clínicas</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link href="/sistema_clinicas/assets/css/style.css" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    
    <!-- jQuery Mask Plugin -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
</head>
<body>
    <?php if (isset($_SESSION['usuario_id'])): ?>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="/sistema_clinicas/dashboard.php">
                <i class="fas fa-clinic-medical me-2"></i>
                Sistema de Clínicas
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-building me-1"></i>Clínicas
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/clinicas/listar.php">
                                <i class="fas fa-list me-2"></i>Listar Clínicas
                            </a></li>
                            <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/clinicas/cadastrar.php">
                                <i class="fas fa-plus me-2"></i>Cadastrar Clínica
                            </a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-md me-1"></i>Profissionais
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/profissionais/listar.php">
                                <i class="fas fa-list me-2"></i>Listar Profissionais
                            </a></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/profissionais/cadastrar.php">
                                <i class="fas fa-plus me-2"></i>Cadastrar Profissional
                            </a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-calendar-alt me-1"></i>Agenda
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/agendamentos/agenda.php">
                                <i class="fas fa-calendar me-2"></i>Visualizar Agenda
                            </a></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/agendamentos/novo.php">
                                <i class="fas fa-plus me-2"></i>Novo Agendamento
                            </a></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/agendamentos/atendimentos_dia.php">
                                <i class="fas fa-check me-2"></i>Atendimentos do Dia
                            </a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-chart-line me-1"></i>Financeiro
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/financeiro/fechamento.php">
                                <i class="fas fa-calculator me-2"></i>Fechamento Diário
                            </a></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/financeiro/relatorio_periodo.php">
                                <i class="fas fa-chart-bar me-2"></i>Relatório por Período
                            </a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-search me-1"></i>Consultas
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/relatorios/agendamentos_dia.php">
                                <i class="fas fa-calendar-day me-2"></i>Agendamentos do Dia
                            </a></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/relatorios/agendamentos_periodo.php">
                                <i class="fas fa-calendar-week me-2"></i>Agendamentos por Período
                            </a></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/relatorios/faltantes.php">
                                <i class="fas fa-user-times me-2"></i>Pacientes Faltantes
                            </a></li>
                        </ul>
                    </li>
                    
                    <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog me-1"></i>Configurações
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/usuarios/listar.php">
                                <i class="fas fa-users me-2"></i>Usuários
                            </a></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/modules/financeiro/tipos_exames.php">
                                <i class="fas fa-table me-2"></i>Tipos de Exames
                            </a></li>
                        </ul>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?php echo $_SESSION['nome_usuario']; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="/sistema_clinicas/perfil.php">
                                <i class="fas fa-user-edit me-2"></i>Meu Perfil
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="/sistema_clinicas/logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>Sair
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <?php endif; ?>
    
    <!-- Main Content -->
    <div class="container-fluid mt-4">
