<?php
/**
 * Sistema de Controle e Administração Financeira de Clínicas
 * Instalador e Configuração Inicial
 * 
 * Este arquivo deve ser executado apenas uma vez para configurar o sistema
 */

// Verificar se já foi instalado
if (file_exists('config/installed.lock')) {
    die('Sistema já foi instalado. Para reinstalar, delete o arquivo config/installed.lock');
}

$erro = '';
$sucesso = '';
$etapa = $_GET['etapa'] ?? 1;

// Configurações padrão
$config_db = [
    'host' => 'localhost',
    'dbname' => 'sistema_clinicas',
    'username' => 'root',
    'password' => ''
];

$admin_user = [
    'nome' => 'Administrador',
    'email' => 'admin@sistema.com',
    'senha' => 'admin123'
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($etapa == 1) {
        // Configuração do banco de dados
        $config_db['host'] = $_POST['db_host'] ?? 'localhost';
        $config_db['dbname'] = $_POST['db_name'] ?? 'sistema_clinicas';
        $config_db['username'] = $_POST['db_user'] ?? 'root';
        $config_db['password'] = $_POST['db_pass'] ?? '';
        
        // Testar conexão
        try {
            $dsn = "mysql:host={$config_db['host']};charset=utf8mb4";
            $pdo = new PDO($dsn, $config_db['username'], $config_db['password']);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Criar banco se não existir
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$config_db['dbname']}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            
            // Salvar configuração
            $config_content = "<?php\n";
            $config_content .= "// Configurações do Banco de Dados\n";
            $config_content .= "define('DB_HOST', '{$config_db['host']}');\n";
            $config_content .= "define('DB_NAME', '{$config_db['dbname']}');\n";
            $config_content .= "define('DB_USER', '{$config_db['username']}');\n";
            $config_content .= "define('DB_PASS', '{$config_db['password']}');\n";
            $config_content .= "?>";
            
            file_put_contents('config/database_config.php', $config_content);
            
            $sucesso = 'Conexão com banco de dados estabelecida com sucesso!';
            $etapa = 2;
            
        } catch (PDOException $e) {
            $erro = 'Erro ao conectar com o banco de dados: ' . $e->getMessage();
        }
        
    } elseif ($etapa == 2) {
        // Criar tabelas
        try {
            require_once 'config/database_config.php';
            
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
            $pdo = new PDO($dsn, DB_USER, DB_PASS);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Ler e executar script SQL
            $sql_script = file_get_contents('database_schema.sql');
            $statements = explode(';', $sql_script);
            
            foreach ($statements as $statement) {
                $statement = trim($statement);
                if (!empty($statement)) {
                    $pdo->exec($statement);
                }
            }
            
            $sucesso = 'Tabelas criadas com sucesso!';
            $etapa = 3;
            
        } catch (PDOException $e) {
            $erro = 'Erro ao criar tabelas: ' . $e->getMessage();
        }
        
    } elseif ($etapa == 3) {
        // Criar usuário administrador
        $admin_user['nome'] = $_POST['admin_nome'] ?? 'Administrador';
        $admin_user['email'] = $_POST['admin_email'] ?? 'admin@sistema.com';
        $admin_user['senha'] = $_POST['admin_senha'] ?? 'admin123';
        
        try {
            require_once 'config/database_config.php';
            require_once 'modules/usuarios/Usuario.php';
            
            $usuario = new Usuario();
            $usuario->nome_usuario = $admin_user['nome'];
            $usuario->email = $admin_user['email'];
            $usuario->senha = $admin_user['senha'];
            $usuario->perfil_acesso = 'Administrador';
            $usuario->id_clinica = null;
            $usuario->ativo = true;
            
            if ($usuario->criar()) {
                $sucesso = 'Usuário administrador criado com sucesso!';
                $etapa = 4;
            } else {
                $erro = 'Erro ao criar usuário administrador.';
            }
            
        } catch (Exception $e) {
            $erro = 'Erro ao criar usuário: ' . $e->getMessage();
        }
        
    } elseif ($etapa == 4) {
        // Finalizar instalação
        try {
            // Criar arquivo de lock
            file_put_contents('config/installed.lock', date('Y-m-d H:i:s'));
            
            // Criar dados de exemplo (opcional)
            if (isset($_POST['dados_exemplo'])) {
                criarDadosExemplo();
            }
            
            $sucesso = 'Sistema instalado com sucesso!';
            $etapa = 5;
            
        } catch (Exception $e) {
            $erro = 'Erro ao finalizar instalação: ' . $e->getMessage();
        }
    }
}

function criarDadosExemplo() {
    require_once 'config/database_config.php';
    require_once 'modules/clinicas/Clinica.php';
    require_once 'modules/profissionais/Profissional.php';
    require_once 'modules/tipos_exames/TipoExame.php';
    
    try {
        // Criar clínica exemplo
        $clinica = new Clinica();
        $clinica->nome_clinica = 'Clínica Exemplo';
        $clinica->cnpj = '12.345.678/0001-90';
        $clinica->endereco = 'Rua das Flores, 123';
        $clinica->cidade = 'São Paulo';
        $clinica->estado = 'SP';
        $clinica->cep = '01234-567';
        $clinica->telefone = '(11) 1234-5678';
        $clinica->email = 'contato@clinicaexemplo.com';
        $clinica->ativo = true;
        $clinica->criar();
        
        // Criar tipos de exames exemplo
        $tipos_exames = [
            ['nome' => 'Exame Médico', 'valor' => 150.00, 'descricao' => 'Exame médico geral'],
            ['nome' => 'Exame Psicológico', 'valor' => 120.00, 'descricao' => 'Avaliação psicológica'],
            ['nome' => 'Exame Médico + Psicológico', 'valor' => 250.00, 'descricao' => 'Exame completo']
        ];
        
        foreach ($tipos_exames as $tipo_data) {
            $tipo = new TipoExame();
            $tipo->nome_tipo_exame = $tipo_data['nome'];
            $tipo->valor_exame = $tipo_data['valor'];
            $tipo->descricao = $tipo_data['descricao'];
            $tipo->ativo = true;
            $tipo->criar();
        }
        
        // Criar profissionais exemplo
        $profissional1 = new Profissional();
        $profissional1->id_clinica = 1;
        $profissional1->nome_completo = 'Dr. João Silva';
        $profissional1->cpf = '123.456.789-01';
        $profissional1->registro_conselho = 'CRM-SP 123456';
        $profissional1->tipo_registro = 'Medico';
        $profissional1->salario = 5000.00;
        $profissional1->ativo = true;
        $profissional1->criar();
        
        $profissional2 = new Profissional();
        $profissional2->id_clinica = 1;
        $profissional2->nome_completo = 'Dra. Maria Santos';
        $profissional2->cpf = '987.654.321-09';
        $profissional2->registro_conselho = 'CRP-SP 06/123456';
        $profissional2->tipo_registro = 'Psicologo';
        $profissional2->salario = 4500.00;
        $profissional2->ativo = true;
        $profissional2->criar();
        
    } catch (Exception $e) {
        // Log do erro, mas não interrompe a instalação
        error_log("Erro ao criar dados de exemplo: " . $e->getMessage());
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalação - Sistema de Clínicas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .install-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .install-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .install-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .install-body {
            padding: 40px;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 30px;
        }
        
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e9ecef;
            color: #6c757d;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
            font-weight: bold;
            position: relative;
        }
        
        .step.active {
            background: #667eea;
            color: white;
        }
        
        .step.completed {
            background: #28a745;
            color: white;
        }
        
        .step:not(:last-child)::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 100%;
            width: 20px;
            height: 2px;
            background: #e9ecef;
            transform: translateY(-50%);
        }
        
        .step.completed:not(:last-child)::after {
            background: #28a745;
        }
        
        .form-floating {
            margin-bottom: 20px;
        }
        
        .btn-install {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 12px 30px;
            border-radius: 25px;
            color: white;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-install:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
            color: white;
        }
        
        .success-icon {
            font-size: 4rem;
            color: #28a745;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <div class="install-card">
            <div class="install-header">
                <h1><i class="fas fa-hospital-alt me-3"></i>Sistema de Clínicas</h1>
                <p class="mb-0">Instalação e Configuração Inicial</p>
            </div>
            
            <div class="install-body">
                <!-- Indicador de Etapas -->
                <div class="step-indicator">
                    <div class="step <?php echo $etapa >= 1 ? ($etapa > 1 ? 'completed' : 'active') : ''; ?>">1</div>
                    <div class="step <?php echo $etapa >= 2 ? ($etapa > 2 ? 'completed' : 'active') : ''; ?>">2</div>
                    <div class="step <?php echo $etapa >= 3 ? ($etapa > 3 ? 'completed' : 'active') : ''; ?>">3</div>
                    <div class="step <?php echo $etapa >= 4 ? ($etapa > 4 ? 'completed' : 'active') : ''; ?>">4</div>
                    <div class="step <?php echo $etapa >= 5 ? 'completed' : ''; ?>">5</div>
                </div>
                
                <?php if (!empty($erro)): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <?php echo $erro; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($sucesso)): ?>
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        <?php echo $sucesso; ?>
                    </div>
                <?php endif; ?>
                
                <?php if ($etapa == 1): ?>
                    <!-- Etapa 1: Configuração do Banco de Dados -->
                    <h3><i class="fas fa-database me-2"></i>Configuração do Banco de Dados</h3>
                    <p class="text-muted mb-4">Configure a conexão com o banco de dados MySQL.</p>
                    
                    <form method="POST" action="?etapa=1">
                        <div class="form-floating">
                            <input type="text" class="form-control" id="db_host" name="db_host" 
                                   value="<?php echo $config_db['host']; ?>" placeholder="localhost">
                            <label for="db_host"><i class="fas fa-server me-2"></i>Servidor</label>
                        </div>
                        
                        <div class="form-floating">
                            <input type="text" class="form-control" id="db_name" name="db_name" 
                                   value="<?php echo $config_db['dbname']; ?>" placeholder="sistema_clinicas">
                            <label for="db_name"><i class="fas fa-database me-2"></i>Nome do Banco</label>
                        </div>
                        
                        <div class="form-floating">
                            <input type="text" class="form-control" id="db_user" name="db_user" 
                                   value="<?php echo $config_db['username']; ?>" placeholder="root">
                            <label for="db_user"><i class="fas fa-user me-2"></i>Usuário</label>
                        </div>
                        
                        <div class="form-floating">
                            <input type="password" class="form-control" id="db_pass" name="db_pass" 
                                   value="<?php echo $config_db['password']; ?>" placeholder="senha">
                            <label for="db_pass"><i class="fas fa-lock me-2"></i>Senha</label>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-install">
                                <i class="fas fa-arrow-right me-2"></i>
                                Testar Conexão e Continuar
                            </button>
                        </div>
                    </form>
                    
                <?php elseif ($etapa == 2): ?>
                    <!-- Etapa 2: Criação das Tabelas -->
                    <h3><i class="fas fa-table me-2"></i>Criação das Tabelas</h3>
                    <p class="text-muted mb-4">Agora vamos criar as tabelas necessárias no banco de dados.</p>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Atenção:</strong> Este processo criará todas as tabelas necessárias para o funcionamento do sistema.
                    </div>
                    
                    <form method="POST" action="?etapa=2">
                        <div class="d-grid">
                            <button type="submit" class="btn btn-install">
                                <i class="fas fa-cogs me-2"></i>
                                Criar Tabelas
                            </button>
                        </div>
                    </form>
                    
                <?php elseif ($etapa == 3): ?>
                    <!-- Etapa 3: Usuário Administrador -->
                    <h3><i class="fas fa-user-shield me-2"></i>Usuário Administrador</h3>
                    <p class="text-muted mb-4">Crie o primeiro usuário administrador do sistema.</p>
                    
                    <form method="POST" action="?etapa=3">
                        <div class="form-floating">
                            <input type="text" class="form-control" id="admin_nome" name="admin_nome" 
                                   value="<?php echo $admin_user['nome']; ?>" placeholder="Administrador" required>
                            <label for="admin_nome"><i class="fas fa-user me-2"></i>Nome Completo</label>
                        </div>
                        
                        <div class="form-floating">
                            <input type="email" class="form-control" id="admin_email" name="admin_email" 
                                   value="<?php echo $admin_user['email']; ?>" placeholder="admin@sistema.com" required>
                            <label for="admin_email"><i class="fas fa-envelope me-2"></i>Email</label>
                        </div>
                        
                        <div class="form-floating">
                            <input type="password" class="form-control" id="admin_senha" name="admin_senha" 
                                   value="<?php echo $admin_user['senha']; ?>" placeholder="senha" required>
                            <label for="admin_senha"><i class="fas fa-lock me-2"></i>Senha</label>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-install">
                                <i class="fas fa-user-plus me-2"></i>
                                Criar Administrador
                            </button>
                        </div>
                    </form>
                    
                <?php elseif ($etapa == 4): ?>
                    <!-- Etapa 4: Finalização -->
                    <h3><i class="fas fa-check-circle me-2"></i>Finalização</h3>
                    <p class="text-muted mb-4">Últimas configurações antes de finalizar a instalação.</p>
                    
                    <form method="POST" action="?etapa=4">
                        <div class="form-check mb-4">
                            <input class="form-check-input" type="checkbox" id="dados_exemplo" name="dados_exemplo" checked>
                            <label class="form-check-label" for="dados_exemplo">
                                <i class="fas fa-database me-2"></i>
                                Criar dados de exemplo (clínica, profissionais e tipos de exames)
                            </label>
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Importante:</strong> Após a instalação, delete este arquivo (install.php) por segurança.
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-install">
                                <i class="fas fa-rocket me-2"></i>
                                Finalizar Instalação
                            </button>
                        </div>
                    </form>
                    
                <?php elseif ($etapa == 5): ?>
                    <!-- Etapa 5: Sucesso -->
                    <div class="text-center">
                        <i class="fas fa-check-circle success-icon"></i>
                        <h3>Instalação Concluída!</h3>
                        <p class="text-muted mb-4">O sistema foi instalado com sucesso e está pronto para uso.</p>
                        
                        <div class="alert alert-success text-start">
                            <h6><i class="fas fa-user-shield me-2"></i>Dados de Acesso:</h6>
                            <p class="mb-1"><strong>Email:</strong> <?php echo $admin_user['email']; ?></p>
                            <p class="mb-0"><strong>Senha:</strong> <?php echo $admin_user['senha']; ?></p>
                        </div>
                        
                        <div class="alert alert-warning text-start">
                            <h6><i class="fas fa-shield-alt me-2"></i>Próximos Passos:</h6>
                            <ol class="mb-0">
                                <li>Delete o arquivo <code>install.php</code> por segurança</li>
                                <li>Altere a senha do administrador após o primeiro login</li>
                                <li>Configure as clínicas e usuários do sistema</li>
                                <li>Faça backup regular do banco de dados</li>
                            </ol>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <a href="login.php" class="btn btn-install">
                                <i class="fas fa-sign-in-alt me-2"></i>
                                Acessar o Sistema
                            </a>
                            <a href="dashboard.php" class="btn btn-outline-primary">
                                <i class="fas fa-tachometer-alt me-2"></i>
                                Ir para o Dashboard
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Informações do Sistema -->
        <div class="text-center mt-4">
            <small class="text-white-50">
                Sistema de Controle e Administração Financeira de Clínicas v1.0<br>
                Desenvolvido com PHP, MySQL e Bootstrap
            </small>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
