<?php
require_once '../../config/config.php';
require_once 'Agendamento.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

$page_title = 'Agenda de Atendimentos';

// Obter mês e ano atual ou da URL
$mes = $_GET['mes'] ?? date('m');
$ano = $_GET['ano'] ?? date('Y');

// Validar mês e ano
$mes = max(1, min(12, intval($mes)));
$ano = max(2020, min(2030, intval($ano)));

// Instanciar classes
$agendamento = new Agendamento();
$clinica = new Clinica();

// Obter clínica do usuário (se não for administrador)
$id_clinica_filtro = null;
if ($_SESSION['perfil_acesso'] !== 'Administrador') {
    $id_clinica_filtro = $_SESSION['id_clinica'];
}

// Obter agendamentos do mês
$agendamentos_mes = $agendamento->obterAgendamentosMes($ano, $mes, $id_clinica_filtro);

// Criar array associativo para facilitar busca
$agendamentos_por_dia = [];
foreach ($agendamentos_mes as $ag) {
    $dia = date('j', strtotime($ag['data']));
    $agendamentos_por_dia[$dia] = $ag;
}

// Obter data selecionada
$data_selecionada = $_GET['data'] ?? date('Y-m-d');
$agendamentos_dia = [];

if ($data_selecionada) {
    $stmt = $agendamento->listarPorData($data_selecionada, $id_clinica_filtro);
    $agendamentos_dia = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Configurar nomes dos meses
$nomes_meses = [
    1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril',
    5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto',
    9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro'
];

$nomes_dias = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'];

// Calcular primeiro dia do mês e total de dias
$primeiro_dia = date('w', mktime(0, 0, 0, $mes, 1, $ano));
$total_dias = date('t', mktime(0, 0, 0, $mes, 1, $ano));

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-calendar me-2 text-primary"></i>
                Agenda de Atendimentos
            </h1>
            <a href="novo.php" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>
                Novo Agendamento
            </a>
        </div>
    </div>
</div>

<div class="row">
    <!-- Calendário -->
    <div class="col-lg-8 mb-4">
        <div class="card shadow">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-calendar-alt me-2"></i>
                    <?php echo $nomes_meses[$mes] . ' ' . $ano; ?>
                </h5>
                <div class="btn-group" role="group">
                    <a href="?mes=<?php echo $mes == 1 ? 12 : $mes - 1; ?>&ano=<?php echo $mes == 1 ? $ano - 1 : $ano; ?>&data=<?php echo $data_selecionada; ?>" 
                       class="btn btn-outline-light btn-sm">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                    <a href="?mes=<?php echo date('m'); ?>&ano=<?php echo date('Y'); ?>&data=<?php echo date('Y-m-d'); ?>" 
                       class="btn btn-outline-light btn-sm">
                        Hoje
                    </a>
                    <a href="?mes=<?php echo $mes == 12 ? 1 : $mes + 1; ?>&ano=<?php echo $mes == 12 ? $ano + 1 : $ano; ?>&data=<?php echo $data_selecionada; ?>" 
                       class="btn btn-outline-light btn-sm">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="calendar-container">
                    <table class="table table-bordered mb-0">
                        <thead class="bg-light">
                            <tr>
                                <?php foreach ($nomes_dias as $dia): ?>
                                    <th class="text-center py-2"><?php echo $dia; ?></th>
                                <?php endforeach; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $dia_atual = 1;
                            $semanas = ceil(($primeiro_dia + $total_dias) / 7);
                            
                            for ($semana = 0; $semana < $semanas; $semana++):
                            ?>
                            <tr>
                                <?php for ($dia_semana = 0; $dia_semana < 7; $dia_semana++): ?>
                                    <td class="calendar-day p-2" style="height: 120px; vertical-align: top;">
                                        <?php
                                        $mostrar_dia = false;
                                        
                                        if ($semana == 0 && $dia_semana >= $primeiro_dia) {
                                            $mostrar_dia = true;
                                        } elseif ($semana > 0 && $dia_atual <= $total_dias) {
                                            $mostrar_dia = true;
                                        }
                                        
                                        if ($mostrar_dia && $dia_atual <= $total_dias):
                                            $data_dia = sprintf('%04d-%02d-%02d', $ano, $mes, $dia_atual);
                                            $is_hoje = $data_dia == date('Y-m-d');
                                            $is_selecionado = $data_dia == $data_selecionada;
                                            $tem_agendamentos = isset($agendamentos_por_dia[$dia_atual]);
                                            
                                            $classes = ['calendar-day-content'];
                                            if ($is_hoje) $classes[] = 'bg-warning';
                                            if ($is_selecionado) $classes[] = 'bg-primary text-white';
                                            if ($tem_agendamentos && !$is_selecionado) $classes[] = 'has-appointments';
                                        ?>
                                            <div class="<?php echo implode(' ', $classes); ?> p-2 rounded cursor-pointer h-100" 
                                                 onclick="selecionarDia('<?php echo $data_dia; ?>')">
                                                <div class="d-flex justify-content-between align-items-start">
                                                    <strong><?php echo $dia_atual; ?></strong>
                                                    <?php if ($is_hoje): ?>
                                                        <small class="badge bg-dark">Hoje</small>
                                                    <?php endif; ?>
                                                </div>
                                                
                                                <?php if ($tem_agendamentos): ?>
                                                    <div class="mt-1">
                                                        <small class="d-block">
                                                            <i class="fas fa-calendar-check me-1"></i>
                                                            <?php echo $agendamentos_por_dia[$dia_atual]['total']; ?> agendamento<?php echo $agendamentos_por_dia[$dia_atual]['total'] > 1 ? 's' : ''; ?>
                                                        </small>
                                                        
                                                        <?php if ($agendamentos_por_dia[$dia_atual]['presentes'] > 0): ?>
                                                            <small class="d-block text-success">
                                                                <i class="fas fa-check me-1"></i>
                                                                <?php echo $agendamentos_por_dia[$dia_atual]['presentes']; ?> presente<?php echo $agendamentos_por_dia[$dia_atual]['presentes'] > 1 ? 's' : ''; ?>
                                                            </small>
                                                        <?php endif; ?>
                                                        
                                                        <?php if ($agendamentos_por_dia[$dia_atual]['faltas'] > 0): ?>
                                                            <small class="d-block text-danger">
                                                                <i class="fas fa-times me-1"></i>
                                                                <?php echo $agendamentos_por_dia[$dia_atual]['faltas']; ?> falta<?php echo $agendamentos_por_dia[$dia_atual]['faltas'] > 1 ? 's' : ''; ?>
                                                            </small>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <?php $dia_atual++; ?>
                                        <?php endif; ?>
                                    </td>
                                <?php endfor; ?>
                            </tr>
                            <?php endfor; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Agendamentos do Dia -->
    <div class="col-lg-4 mb-4">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-calendar-day me-2"></i>
                    Agendamentos - <?php echo date('d/m/Y', strtotime($data_selecionada)); ?>
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($agendamentos_dia)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                        <h6 class="text-muted">Nenhum agendamento</h6>
                        <p class="text-muted mb-3">Não há consultas agendadas para este dia.</p>
                        <a href="novo.php?data=<?php echo $data_selecionada; ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus me-2"></i>
                            Agendar Consulta
                        </a>
                    </div>
                <?php else: ?>
                    <div class="agendamentos-lista">
                        <?php foreach ($agendamentos_dia as $ag): ?>
                            <div class="appointment-item <?php echo strtolower($ag['status_atendimento']); ?> mb-3">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">
                                            <i class="fas fa-user me-2"></i>
                                            <?php echo htmlspecialchars($ag['nome_paciente']); ?>
                                        </h6>
                                        <p class="mb-1">
                                            <small class="text-muted">
                                                <i class="fas fa-clock me-1"></i>
                                                <?php echo date('H:i', strtotime($ag['data_hora_consulta'])); ?>
                                                
                                                <i class="fas fa-stethoscope ms-3 me-1"></i>
                                                <?php echo htmlspecialchars($ag['tipo_exame_agendado']); ?>
                                            </small>
                                        </p>
                                        
                                        <?php if (!empty($ag['nome_profissional'])): ?>
                                            <p class="mb-1">
                                                <small class="text-muted">
                                                    <i class="fas fa-user-md me-1"></i>
                                                    <?php echo htmlspecialchars($ag['nome_profissional']); ?>
                                                </small>
                                            </p>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($ag['telefone_contato'])): ?>
                                            <p class="mb-1">
                                                <a href="#" onclick="abrirWhatsApp('<?php echo $ag['telefone_contato']; ?>', '<?php echo htmlspecialchars($ag['nome_paciente']); ?>')" 
                                                   class="btn btn-sm whatsapp-btn">
                                                    <i class="fab fa-whatsapp me-1"></i>
                                                    <?php echo formatarTelefone($ag['telefone_contato']); ?>
                                                </a>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="ms-2">
                                        <span class="badge status-<?php echo strtolower($ag['status_atendimento']); ?>">
                                            <?php echo $ag['status_atendimento']; ?>
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="mt-2">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="visualizar.php?id=<?php echo $ag['id_agendamento']; ?>" 
                                           class="btn btn-outline-info" title="Visualizar">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <?php if ($ag['status_atendimento'] === 'Agendado'): ?>
                                            <a href="marcar_presenca.php?id=<?php echo $ag['id_agendamento']; ?>" 
                                               class="btn btn-outline-success" title="Marcar Presença">
                                                <i class="fas fa-check"></i>
                                            </a>
                                            <a href="marcar_falta.php?id=<?php echo $ag['id_agendamento']; ?>" 
                                               class="btn btn-outline-danger" title="Marcar Falta">
                                                <i class="fas fa-times"></i>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <a href="editar.php?id=<?php echo $ag['id_agendamento']; ?>" 
                                           class="btn btn-outline-warning" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="text-center mt-3">
                        <a href="novo.php?data=<?php echo $data_selecionada; ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus me-2"></i>
                            Novo Agendamento
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
.calendar-day-content {
    cursor: pointer;
    transition: all 0.3s ease;
    border-radius: 0.375rem;
}

.calendar-day-content:hover {
    background-color: rgba(13, 110, 253, 0.1) !important;
    transform: scale(1.02);
}

.has-appointments {
    background-color: rgba(25, 135, 84, 0.1);
    border: 1px solid rgba(25, 135, 84, 0.3);
}

.agendamentos-lista {
    max-height: 600px;
    overflow-y: auto;
}

.appointment-item {
    transition: all 0.3s ease;
}

.appointment-item:hover {
    transform: translateX(5px);
    box-shadow: 0 0.25rem 0.5rem rgba(0, 0, 0, 0.1);
}
</style>

<script>
function selecionarDia(data) {
    const url = new URL(window.location);
    url.searchParams.set('data', data);
    window.location.href = url.toString();
}

function abrirWhatsApp(telefone, nomePaciente) {
    const mensagem = `Olá ${nomePaciente}, este é um lembrete sobre sua consulta agendada.`;
    const url = gerarLinkWhatsApp(telefone, mensagem);
    window.open(url, '_blank');
}

// Atualizar página a cada 5 minutos para mostrar novos agendamentos
setInterval(function() {
    location.reload();
}, 300000);
</script>

<?php include '../../includes/footer.php'; ?>
