<?php
require_once '../../config/config.php';
require_once 'Agendamento.php';
require_once '../pacientes/Paciente.php';
require_once '../profissionais/Profissional.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

$page_title = 'Novo Agendamento';

$erro = '';
$sucesso = '';

// Instanciar classes
$agendamento = new Agendamento();
$paciente = new Paciente();
$profissional = new Profissional();
$clinica = new Clinica();

// Obter listas para os selects
$stmt_clinicas = $clinica->listarTodas();
$clinicas = $stmt_clinicas->fetchAll(PDO::FETCH_ASSOC);

$stmt_profissionais = $profissional->listarTodos();
$profissionais = $stmt_profissionais->fetchAll(PDO::FETCH_ASSOC);

// Data pré-selecionada (se vier da agenda)
$data_pre_selecionada = $_GET['data'] ?? date('Y-m-d');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Dados do paciente
    $nome_paciente = $_POST['nome_paciente'] ?? '';
    $cpf_paciente = $_POST['cpf_paciente'] ?? '';
    $renach = $_POST['renach'] ?? '';
    $telefone_contato = $_POST['telefone_contato'] ?? '';
    
    // Dados do agendamento
    $id_clinica = $_POST['id_clinica'] ?? '';
    $id_profissional = $_POST['id_profissional'] ?? '';
    $data_consulta = $_POST['data_consulta'] ?? '';
    $hora_consulta = $_POST['hora_consulta'] ?? '';
    $tipo_exame = $_POST['tipo_exame'] ?? '';
    $observacao = $_POST['observacao'] ?? '';
    
    // Validações
    if (empty($nome_paciente)) {
        $erro = 'O nome do paciente é obrigatório.';
    } elseif (empty($cpf_paciente)) {
        $erro = 'O CPF do paciente é obrigatório.';
    } elseif (empty($id_clinica)) {
        $erro = 'Selecione uma clínica.';
    } elseif (empty($data_consulta)) {
        $erro = 'A data da consulta é obrigatória.';
    } elseif (empty($hora_consulta)) {
        $erro = 'O horário da consulta é obrigatório.';
    } elseif (empty($tipo_exame)) {
        $erro = 'O tipo de exame é obrigatório.';
    } else {
        // Verificar se a data/hora não é no passado
        $data_hora_consulta = $data_consulta . ' ' . $hora_consulta . ':00';
        if (strtotime($data_hora_consulta) < time()) {
            $erro = 'Não é possível agendar para uma data/hora no passado.';
        } else {
            // Verificar disponibilidade do profissional (se selecionado)
            if (!empty($id_profissional)) {
                if (!$agendamento->verificarDisponibilidade($data_hora_consulta, $id_profissional)) {
                    $erro = 'Este horário já está ocupado para o profissional selecionado.';
                }
            }
            
            if (empty($erro)) {
                try {
                    // Primeiro, criar ou atualizar o paciente
                    $paciente->nome_paciente = $nome_paciente;
                    $paciente->cpf = $cpf_paciente;
                    $paciente->renach = $renach;
                    $paciente->telefone_contato = $telefone_contato;
                    
                    if ($paciente->criarOuAtualizar()) {
                        // Agora criar o agendamento
                        $agendamento->id_clinica = $id_clinica;
                        $agendamento->id_paciente = $paciente->id_paciente;
                        $agendamento->id_profissional = !empty($id_profissional) ? $id_profissional : null;
                        $agendamento->data_hora_consulta = $data_hora_consulta;
                        $agendamento->tipo_exame_agendado = $tipo_exame;
                        $agendamento->observacao_agendamento = $observacao;
                        
                        if ($agendamento->criar()) {
                            $sucesso = 'Agendamento criado com sucesso!';
                            // Limpar campos
                            $nome_paciente = $cpf_paciente = $renach = $telefone_contato = '';
                            $id_clinica = $id_profissional = $data_consulta = $hora_consulta = $tipo_exame = $observacao = '';
                        } else {
                            $erro = 'Erro ao criar agendamento. Tente novamente.';
                        }
                    } else {
                        $erro = 'Erro ao processar dados do paciente.';
                    }
                } catch (Exception $e) {
                    $erro = 'Erro interno: ' . $e->getMessage();
                }
            }
        }
    }
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-plus me-2 text-primary"></i>
                Novo Agendamento
            </h1>
            <a href="agenda.php" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>
                Voltar à Agenda
            </a>
        </div>
    </div>
</div>

<div class="row justify-content-center">
    <div class="col-lg-10">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-calendar-plus me-2"></i>
                    Dados do Agendamento
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($erro)): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <?php echo $erro; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($sucesso)): ?>
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        <?php echo $sucesso; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" action="" novalidate>
                    <!-- Dados do Paciente -->
                    <div class="card mb-4">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0">
                                <i class="fas fa-user me-2"></i>
                                Dados do Paciente
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nome_paciente" class="form-label">
                                        <i class="fas fa-user me-1"></i>
                                        Nome Completo <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nome_paciente" name="nome_paciente" 
                                           value="<?php echo htmlspecialchars($nome_paciente ?? ''); ?>" 
                                           placeholder="Digite o nome completo do paciente" required>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="cpf_paciente" class="form-label">
                                        <i class="fas fa-id-card me-1"></i>
                                        CPF <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control cpf-mask" id="cpf_paciente" name="cpf_paciente" 
                                           value="<?php echo htmlspecialchars($cpf_paciente ?? ''); ?>" 
                                           placeholder="000.000.000-00" required>
                                    <div class="form-text">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Se o CPF já existir, os dados serão atualizados.
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="renach" class="form-label">
                                        <i class="fas fa-id-badge me-1"></i>
                                        RENACH
                                    </label>
                                    <input type="text" class="form-control" id="renach" name="renach" 
                                           value="<?php echo htmlspecialchars($renach ?? ''); ?>" 
                                           placeholder="Número do RENACH">
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="telefone_contato" class="form-label">
                                        <i class="fas fa-phone me-1"></i>
                                        Telefone de Contato
                                    </label>
                                    <input type="text" class="form-control telefone-mask" id="telefone_contato" name="telefone_contato" 
                                           value="<?php echo htmlspecialchars($telefone_contato ?? ''); ?>" 
                                           placeholder="(00) 00000-0000">
                                    <div class="form-text">
                                        <i class="fab fa-whatsapp me-1"></i>
                                        Será usado para enviar mensagens via WhatsApp.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Dados da Consulta -->
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0">
                                <i class="fas fa-calendar-check me-2"></i>
                                Dados da Consulta
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="id_clinica" class="form-label">
                                        <i class="fas fa-building me-1"></i>
                                        Clínica <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="id_clinica" name="id_clinica" required>
                                        <option value="">Selecione uma clínica</option>
                                        <?php foreach ($clinicas as $clinica_item): ?>
                                            <?php if ($_SESSION['perfil_acesso'] === 'Administrador' || $_SESSION['id_clinica'] == $clinica_item['id_clinica']): ?>
                                                <option value="<?php echo $clinica_item['id_clinica']; ?>" 
                                                        <?php echo ($id_clinica ?? '') == $clinica_item['id_clinica'] ? 'selected' : ''; ?>>
                                                    <?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>
                                                </option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="id_profissional" class="form-label">
                                        <i class="fas fa-user-md me-1"></i>
                                        Profissional
                                    </label>
                                    <select class="form-select" id="id_profissional" name="id_profissional">
                                        <option value="">Selecione um profissional (opcional)</option>
                                        <?php foreach ($profissionais as $prof): ?>
                                            <option value="<?php echo $prof['id_profissional']; ?>" 
                                                    data-tipo="<?php echo $prof['tipo_registro']; ?>"
                                                    <?php echo ($id_profissional ?? '') == $prof['id_profissional'] ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($prof['nome_completo']); ?> 
                                                (<?php echo $prof['tipo_registro']; ?>)
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="data_consulta" class="form-label">
                                        <i class="fas fa-calendar me-1"></i>
                                        Data da Consulta <span class="text-danger">*</span>
                                    </label>
                                    <input type="date" class="form-control" id="data_consulta" name="data_consulta" 
                                           value="<?php echo htmlspecialchars($data_consulta ?? $data_pre_selecionada); ?>" 
                                           min="<?php echo date('Y-m-d'); ?>" required>
                                </div>
                                
                                <div class="col-md-4 mb-3">
                                    <label for="hora_consulta" class="form-label">
                                        <i class="fas fa-clock me-1"></i>
                                        Horário <span class="text-danger">*</span>
                                    </label>
                                    <input type="time" class="form-control" id="hora_consulta" name="hora_consulta" 
                                           value="<?php echo htmlspecialchars($hora_consulta ?? ''); ?>" required>
                                </div>
                                
                                <div class="col-md-4 mb-3">
                                    <label for="tipo_exame" class="form-label">
                                        <i class="fas fa-stethoscope me-1"></i>
                                        Tipo de Exame <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="tipo_exame" name="tipo_exame" required>
                                        <option value="">Selecione o tipo de exame</option>
                                        <option value="Exame Médico" <?php echo ($tipo_exame ?? '') == 'Exame Médico' ? 'selected' : ''; ?>>
                                            Exame Médico
                                        </option>
                                        <option value="Exame Psicológico" <?php echo ($tipo_exame ?? '') == 'Exame Psicológico' ? 'selected' : ''; ?>>
                                            Exame Psicológico
                                        </option>
                                        <option value="Exame Médico + Psicológico" <?php echo ($tipo_exame ?? '') == 'Exame Médico + Psicológico' ? 'selected' : ''; ?>>
                                            Exame Médico + Psicológico
                                        </option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="observacao" class="form-label">
                                        <i class="fas fa-comment me-1"></i>
                                        Observações
                                    </label>
                                    <textarea class="form-control" id="observacao" name="observacao" rows="3" 
                                              placeholder="Observações adicionais sobre o agendamento..."><?php echo htmlspecialchars($observacao ?? ''); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="agenda.php" class="btn btn-outline-secondary me-md-2">
                                    <i class="fas fa-times me-2"></i>
                                    Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-2"></i>
                                    Criar Agendamento
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Informações Adicionais -->
<div class="row mt-4">
    <div class="col-lg-10 mx-auto">
        <div class="card shadow">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0">
                    <i class="fas fa-lightbulb me-2"></i>
                    Dicas Importantes
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6><i class="fas fa-user text-info me-2"></i>Sobre o Paciente</h6>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>Se o CPF já existir, os dados serão atualizados</li>
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>O telefone é usado para contato via WhatsApp</li>
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>O RENACH é opcional</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h6><i class="fas fa-calendar text-success me-2"></i>Sobre o Agendamento</h6>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>Não é possível agendar no passado</li>
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>O profissional é opcional</li>
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>Verifique conflitos de horário</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Buscar paciente por CPF
    $('#cpf_paciente').on('blur', function() {
        var cpf = $(this).val().replace(/[^\d]/g, '');
        
        if (cpf.length === 11) {
            // Aqui você pode implementar uma busca AJAX para preencher os dados do paciente
            // Por enquanto, apenas validamos o CPF
            if (!validarCPF(cpf)) {
                $(this).addClass('is-invalid');
                mostrarToast('CPF Inválido', 'Por favor, digite um CPF válido.', 'danger');
            } else {
                $(this).removeClass('is-invalid');
            }
        }
    });
    
    // Validar horário de funcionamento
    $('#hora_consulta').on('change', function() {
        var hora = $(this).val();
        var horaNum = parseInt(hora.replace(':', ''));
        
        if (horaNum < 700 || horaNum > 1800) {
            mostrarToast('Horário de Funcionamento', 'Recomendamos agendar entre 07:00 e 18:00.', 'warning');
        }
    });
    
    // Verificar disponibilidade do profissional
    $('#id_profissional, #data_consulta, #hora_consulta').on('change', function() {
        var profissional = $('#id_profissional').val();
        var data = $('#data_consulta').val();
        var hora = $('#hora_consulta').val();
        
        if (profissional && data && hora) {
            // Aqui você pode implementar uma verificação AJAX de disponibilidade
            console.log('Verificando disponibilidade para:', profissional, data, hora);
        }
    });
    
    // Sugerir profissional baseado no tipo de exame
    $('#tipo_exame').on('change', function() {
        var tipoExame = $(this).val();
        var profissionalSelect = $('#id_profissional');
        
        if (tipoExame === 'Exame Médico') {
            profissionalSelect.find('option[data-tipo="Medico"]').show();
            profissionalSelect.find('option[data-tipo="Psicologo"]').hide();
        } else if (tipoExame === 'Exame Psicológico') {
            profissionalSelect.find('option[data-tipo="Psicologo"]').show();
            profissionalSelect.find('option[data-tipo="Medico"]').hide();
        } else {
            profissionalSelect.find('option').show();
        }
    });
});
</script>

<?php include '../../includes/footer.php'; ?>
