<?php
require_once '../../config/config.php';
require_once 'Clinica.php';

verificarLogin();
verificarPermissao('Administrador');

$page_title = 'Cadastrar Clínica';

$erro = '';
$sucesso = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome_clinica = $_POST['nome_clinica'] ?? '';
    $cnpj = $_POST['cnpj'] ?? '';
    $endereco = $_POST['endereco'] ?? '';
    $telefone = $_POST['telefone'] ?? '';
    $email = $_POST['email'] ?? '';
    
    // Validações
    if (empty($nome_clinica)) {
        $erro = 'O nome da clínica é obrigatório.';
    } elseif (empty($cnpj)) {
        $erro = 'O CNPJ é obrigatório.';
    } else {
        $clinica = new Clinica();
        
        // Verificar se CNPJ já existe
        if ($clinica->cnpjExiste($cnpj)) {
            $erro = 'Este CNPJ já está cadastrado no sistema.';
        } else {
            // Definir propriedades
            $clinica->nome_clinica = $nome_clinica;
            $clinica->cnpj = $cnpj;
            $clinica->endereco = $endereco;
            $clinica->telefone = $telefone;
            $clinica->email = $email;
            
            // Tentar criar
            if ($clinica->criar()) {
                $sucesso = 'Clínica cadastrada com sucesso!';
                // Limpar campos
                $nome_clinica = $cnpj = $endereco = $telefone = $email = '';
            } else {
                $erro = 'Erro ao cadastrar clínica. Tente novamente.';
            }
        }
    }
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-plus me-2 text-primary"></i>
                Cadastrar Nova Clínica
            </h1>
            <a href="listar.php" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>
                Voltar à Lista
            </a>
        </div>
    </div>
</div>

<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-building me-2"></i>
                    Dados da Clínica
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($erro)): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <?php echo $erro; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($sucesso)): ?>
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        <?php echo $sucesso; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" action="" novalidate>
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="nome_clinica" class="form-label">
                                <i class="fas fa-building me-1"></i>
                                Nome da Clínica <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control" id="nome_clinica" name="nome_clinica" 
                                   value="<?php echo htmlspecialchars($nome_clinica ?? ''); ?>" 
                                   placeholder="Digite o nome da clínica" required>
                            <div class="invalid-feedback">
                                Por favor, informe o nome da clínica.
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="cnpj" class="form-label">
                                <i class="fas fa-id-card me-1"></i>
                                CNPJ <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control cnpj-mask" id="cnpj" name="cnpj" 
                                   value="<?php echo htmlspecialchars($cnpj ?? ''); ?>" 
                                   placeholder="00.000.000/0000-00" required>
                            <div class="invalid-feedback">
                                Por favor, informe um CNPJ válido.
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="telefone" class="form-label">
                                <i class="fas fa-phone me-1"></i>
                                Telefone
                            </label>
                            <input type="text" class="form-control telefone-mask" id="telefone" name="telefone" 
                                   value="<?php echo htmlspecialchars($telefone ?? ''); ?>" 
                                   placeholder="(00) 00000-0000">
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="email" class="form-label">
                                <i class="fas fa-envelope me-1"></i>
                                Email
                            </label>
                            <input type="email" class="form-control" id="email" name="email" 
                                   value="<?php echo htmlspecialchars($email ?? ''); ?>" 
                                   placeholder="contato@clinica.com.br">
                            <div class="invalid-feedback">
                                Por favor, informe um email válido.
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="endereco" class="form-label">
                                <i class="fas fa-map-marker-alt me-1"></i>
                                Endereço Completo
                            </label>
                            <textarea class="form-control" id="endereco" name="endereco" rows="3" 
                                      placeholder="Rua, número, bairro, cidade - UF, CEP"><?php echo htmlspecialchars($endereco ?? ''); ?></textarea>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="listar.php" class="btn btn-outline-secondary me-md-2">
                                    <i class="fas fa-times me-2"></i>
                                    Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-2"></i>
                                    Cadastrar Clínica
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Informações Adicionais -->
<div class="row mt-4">
    <div class="col-lg-8 mx-auto">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informações Importantes
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6><i class="fas fa-check-circle text-success me-2"></i>Campos Obrigatórios</h6>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>Nome da Clínica</li>
                            <li><i class="fas fa-dot-circle text-primary me-2"></i>CNPJ</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h6><i class="fas fa-lightbulb text-warning me-2"></i>Dicas</h6>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-dot-circle text-secondary me-2"></i>O CNPJ deve ser único</li>
                            <li><i class="fas fa-dot-circle text-secondary me-2"></i>Preencha todos os dados para melhor controle</li>
                        </ul>
                    </div>
                </div>
                
                <div class="alert alert-light mt-3" role="alert">
                    <i class="fas fa-file-pdf me-2"></i>
                    <strong>Próximo passo:</strong> Após cadastrar a clínica, você poderá fazer upload dos documentos fiscais necessários.
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Validação personalizada do formulário
    $('form').on('submit', function(e) {
        var isValid = true;
        
        // Validar nome da clínica
        var nomeClinica = $('#nome_clinica').val().trim();
        if (nomeClinica === '') {
            $('#nome_clinica').addClass('is-invalid');
            isValid = false;
        } else {
            $('#nome_clinica').removeClass('is-invalid');
        }
        
        // Validar CNPJ
        var cnpj = $('#cnpj').val().replace(/[^\d]/g, '');
        if (cnpj === '' || cnpj.length !== 14) {
            $('#cnpj').addClass('is-invalid');
            isValid = false;
        } else {
            $('#cnpj').removeClass('is-invalid');
        }
        
        // Validar email se preenchido
        var email = $('#email').val().trim();
        if (email !== '') {
            var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(email)) {
                $('#email').addClass('is-invalid');
                isValid = false;
            } else {
                $('#email').removeClass('is-invalid');
            }
        }
        
        if (!isValid) {
            e.preventDefault();
            mostrarToast('Erro de Validação', 'Por favor, corrija os campos destacados.', 'danger');
        }
    });
    
    // Remover classe de erro ao digitar
    $('.form-control').on('input', function() {
        $(this).removeClass('is-invalid');
    });
});
</script>

<?php include '../../includes/footer.php'; ?>
