<?php
require_once '../../config/config.php';
require_once 'Clinica.php';

verificarLogin();

$page_title = 'Listar Clínicas';

$clinica = new Clinica();
$busca = $_GET['busca'] ?? '';

if (!empty($busca)) {
    $stmt = $clinica->buscar($busca);
} else {
    $stmt = $clinica->listarTodas();
}

$clinicas = $stmt->fetchAll(PDO::FETCH_ASSOC);

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-building me-2 text-primary"></i>
                Clínicas Cadastradas
            </h1>
            <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
            <a href="cadastrar.php" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>
                Nova Clínica
            </a>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Filtros e Busca -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row align-items-end">
                        <div class="col-md-8">
                            <label for="busca" class="form-label">Buscar Clínica</label>
                            <input type="text" class="form-control search-input" id="busca" name="busca" 
                                   value="<?php echo htmlspecialchars($busca); ?>" 
                                   placeholder="Digite o nome, CNPJ ou endereço da clínica...">
                        </div>
                        <div class="col-md-4">
                            <div class="d-grid gap-2 d-md-flex">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>
                                    Buscar
                                </button>
                                <a href="listar.php" class="btn btn-outline-secondary">
                                    <i class="fas fa-times me-2"></i>
                                    Limpar
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Resultados -->
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    Resultados (<?php echo count($clinicas); ?> clínica<?php echo count($clinicas) != 1 ? 's' : ''; ?>)
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($clinicas)): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-search fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Nenhuma clínica encontrada</h5>
                        <p class="text-muted">
                            <?php if (!empty($busca)): ?>
                                Tente refinar sua busca ou 
                                <a href="listar.php">visualizar todas as clínicas</a>.
                            <?php else: ?>
                                Não há clínicas cadastradas no sistema.
                                <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                                    <br><a href="cadastrar.php" class="btn btn-primary mt-3">
                                        <i class="fas fa-plus me-2"></i>
                                        Cadastrar primeira clínica
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Nome da Clínica</th>
                                    <th>CNPJ</th>
                                    <th>Telefone</th>
                                    <th>Email</th>
                                    <th>Data Cadastro</th>
                                    <th width="200">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($clinicas as $clinica_item): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo htmlspecialchars($clinica_item['nome_clinica']); ?></strong>
                                        <?php if (!empty($clinica_item['endereco'])): ?>
                                            <br><small class="text-muted">
                                                <i class="fas fa-map-marker-alt me-1"></i>
                                                <?php echo htmlspecialchars($clinica_item['endereco']); ?>
                                            </small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="font-monospace">
                                            <?php echo formatarCNPJ($clinica_item['cnpj']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if (!empty($clinica_item['telefone'])): ?>
                                            <span class="font-monospace">
                                                <?php echo formatarTelefone($clinica_item['telefone']); ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if (!empty($clinica_item['email'])): ?>
                                            <a href="mailto:<?php echo $clinica_item['email']; ?>">
                                                <?php echo htmlspecialchars($clinica_item['email']); ?>
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            <?php echo date('d/m/Y H:i', strtotime($clinica_item['data_cadastro'])); ?>
                                        </small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="visualizar.php?id=<?php echo $clinica_item['id_clinica']; ?>" 
                                               class="btn btn-sm btn-outline-info" title="Visualizar">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <?php if ($_SESSION['perfil_acesso'] === 'Administrador' || $_SESSION['id_clinica'] == $clinica_item['id_clinica']): ?>
                                            <a href="editar.php?id=<?php echo $clinica_item['id_clinica']; ?>" 
                                               class="btn btn-sm btn-outline-warning" title="Editar">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            
                                            <a href="documentos.php?id=<?php echo $clinica_item['id_clinica']; ?>" 
                                               class="btn btn-sm btn-outline-secondary" title="Documentos">
                                                <i class="fas fa-file-pdf"></i>
                                            </a>
                                            <?php endif; ?>
                                            
                                            <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                                            <a href="excluir.php?id=<?php echo $clinica_item['id_clinica']; ?>" 
                                               class="btn btn-sm btn-outline-danger btn-delete" 
                                               title="Excluir"
                                               data-item="a clínica '<?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>'">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Estatísticas -->
<?php if (!empty($clinicas)): ?>
<div class="row mt-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Estatísticas
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo count($clinicas); ?></h4>
                            <p class="text-muted mb-0">Total de Clínicas</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success">
                                <?php echo count(array_filter($clinicas, function($c) { return !empty($c['telefone']); })); ?>
                            </h4>
                            <p class="text-muted mb-0">Com Telefone</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info">
                                <?php echo count(array_filter($clinicas, function($c) { return !empty($c['email']); })); ?>
                            </h4>
                            <p class="text-muted mb-0">Com Email</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning">
                                <?php echo count(array_filter($clinicas, function($c) { return !empty($c['endereco']); })); ?>
                            </h4>
                            <p class="text-muted mb-0">Com Endereço</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php include '../../includes/footer.php'; ?>
