<?php
require_once '../../config/config.php';
require_once 'FechamentoDiario.php';
require_once 'DespesaDiaria.php';
require_once '../atendimentos/Atendimento.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

$page_title = 'Fechamento Diário';

$erro = '';
$sucesso = '';

// Instanciar classes
$fechamento = new FechamentoDiario();
$despesa = new DespesaDiaria();
$atendimento = new Atendimento();
$clinica = new Clinica();

// Obter data selecionada
$data_selecionada = $_GET['data'] ?? date('Y-m-d');

// Obter clínica do usuário (se não for administrador)
$id_clinica_filtro = null;
if ($_SESSION['perfil_acesso'] !== 'Administrador') {
    $id_clinica_filtro = $_SESSION['id_clinica'];
} else {
    $id_clinica_filtro = $_GET['clinica'] ?? null;
}

// Se for administrador e não selecionou clínica, pegar a primeira
if ($_SESSION['perfil_acesso'] === 'Administrador' && !$id_clinica_filtro) {
    $stmt_clinicas = $clinica->listarTodas();
    $primeira_clinica = $stmt_clinicas->fetch(PDO::FETCH_ASSOC);
    if ($primeira_clinica) {
        $id_clinica_filtro = $primeira_clinica['id_clinica'];
    }
}

// Processar fechamento se solicitado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['processar_fechamento'])) {
    try {
        if ($fechamento->processarFechamento($data_selecionada, $id_clinica_filtro)) {
            $sucesso = 'Fechamento processado com sucesso!';
        } else {
            $erro = 'Erro ao processar fechamento.';
        }
    } catch (Exception $e) {
        $erro = 'Erro: ' . $e->getMessage();
    }
}

// Adicionar despesa se solicitado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['adicionar_despesa'])) {
    $descricao_despesa = $_POST['descricao_despesa'] ?? '';
    $valor_despesa = $_POST['valor_despesa'] ?? '';
    
    if (empty($descricao_despesa) || empty($valor_despesa)) {
        $erro = 'Descrição e valor da despesa são obrigatórios.';
    } else {
        $despesa->id_clinica = $id_clinica_filtro;
        $despesa->data_despesa = $data_selecionada;
        $despesa->descricao = $descricao_despesa;
        $despesa->valor = $valor_despesa;
        
        if ($despesa->criar()) {
            $sucesso = 'Despesa adicionada com sucesso!';
        } else {
            $erro = 'Erro ao adicionar despesa.';
        }
    }
}

// Obter dados do dia
$atendimentos_dia = [];
$despesas_dia = [];
$fechamento_existente = null;

if ($id_clinica_filtro) {
    // Obter atendimentos do dia
    $stmt_atendimentos = $atendimento->listarPorData($data_selecionada, $id_clinica_filtro);
    $atendimentos_dia = $stmt_atendimentos->fetchAll(PDO::FETCH_ASSOC);
    
    // Obter despesas do dia
    $stmt_despesas = $despesa->listarPorData($data_selecionada, $id_clinica_filtro);
    $despesas_dia = $stmt_despesas->fetchAll(PDO::FETCH_ASSOC);
    
    // Verificar se já existe fechamento
    $fechamento_existente = $fechamento->obterFechamentoPorData($data_selecionada, $id_clinica_filtro);
}

// Obter lista de clínicas para administrador
$clinicas = [];
if ($_SESSION['perfil_acesso'] === 'Administrador') {
    $stmt_clinicas = $clinica->listarTodas();
    $clinicas = $stmt_clinicas->fetchAll(PDO::FETCH_ASSOC);
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-calculator me-2 text-primary"></i>
                Fechamento Diário
            </h1>
            <div class="d-flex gap-2">
                <a href="../agendamentos/agenda.php" class="btn btn-outline-secondary">
                    <i class="fas fa-calendar me-2"></i>
                    Ver Agenda
                </a>
                <a href="relatorio_periodo.php" class="btn btn-outline-info">
                    <i class="fas fa-chart-line me-2"></i>
                    Relatórios
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row align-items-end">
                        <div class="col-md-4">
                            <label for="data" class="form-label">Data do Fechamento</label>
                            <input type="date" class="form-control" id="data" name="data" 
                                   value="<?php echo $data_selecionada; ?>" 
                                   max="<?php echo date('Y-m-d'); ?>">
                        </div>
                        
                        <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                        <div class="col-md-4">
                            <label for="clinica" class="form-label">Clínica</label>
                            <select class="form-select" id="clinica" name="clinica">
                                <?php foreach ($clinicas as $clinica_item): ?>
                                    <option value="<?php echo $clinica_item['id_clinica']; ?>" 
                                            <?php echo $id_clinica_filtro == $clinica_item['id_clinica'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-md-4">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>
                                    Carregar Dados
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if (!empty($erro)): ?>
    <div class="alert alert-danger" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        <?php echo $erro; ?>
    </div>
<?php endif; ?>

<?php if (!empty($sucesso)): ?>
    <div class="alert alert-success" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        <?php echo $sucesso; ?>
    </div>
<?php endif; ?>

<?php if ($id_clinica_filtro): ?>
<!-- Resumo do Dia -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-calendar-day me-2"></i>
                    Resumo do Dia - <?php echo date('d/m/Y', strtotime($data_selecionada)); ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success">
                                R$ <?php echo number_format(array_sum(array_column($atendimentos_dia, 'valor_pago')), 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Total Recebido</p>
                            <small class="text-muted"><?php echo count($atendimentos_dia); ?> atendimento<?php echo count($atendimentos_dia) != 1 ? 's' : ''; ?></small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-danger">
                                R$ <?php echo number_format(array_sum(array_column($despesas_dia, 'valor')), 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Total Despesas</p>
                            <small class="text-muted"><?php echo count($despesas_dia); ?> despesa<?php echo count($despesas_dia) != 1 ? 's' : ''; ?></small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <?php 
                            $saldo = array_sum(array_column($atendimentos_dia, 'valor_pago')) - array_sum(array_column($despesas_dia, 'valor'));
                            $cor_saldo = $saldo >= 0 ? 'text-success' : 'text-danger';
                            ?>
                            <h4 class="<?php echo $cor_saldo; ?>">
                                R$ <?php echo number_format($saldo, 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Saldo do Dia</p>
                            <small class="text-muted">
                                <?php echo $saldo >= 0 ? 'Lucro' : 'Prejuízo'; ?>
                            </small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <?php if ($fechamento_existente): ?>
                                <span class="badge bg-success fs-6">
                                    <i class="fas fa-check me-1"></i>
                                    Fechado
                                </span>
                                <p class="text-muted mb-0 mt-2">Fechamento Realizado</p>
                            <?php else: ?>
                                <span class="badge bg-warning fs-6">
                                    <i class="fas fa-clock me-1"></i>
                                    Pendente
                                </span>
                                <p class="text-muted mb-0 mt-2">Aguardando Fechamento</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Atendimentos e Despesas -->
<div class="row mb-4">
    <!-- Atendimentos do Dia -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">
                    <i class="fas fa-stethoscope me-2"></i>
                    Atendimentos Realizados (<?php echo count($atendimentos_dia); ?>)
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($atendimentos_dia)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-stethoscope fa-3x text-muted mb-3"></i>
                        <h6 class="text-muted">Nenhum atendimento realizado</h6>
                        <p class="text-muted">Não há atendimentos registrados para este dia.</p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Paciente</th>
                                    <th>Exame</th>
                                    <th>Profissional</th>
                                    <th>Valor</th>
                                    <th>Pagamento</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($atendimentos_dia as $at): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo htmlspecialchars($at['nome_paciente']); ?></strong>
                                        <br><small class="text-muted"><?php echo formatarCPF($at['cpf']); ?></small>
                                    </td>
                                    <td><?php echo htmlspecialchars($at['tipo_exame_realizado']); ?></td>
                                    <td>
                                        <small><?php echo htmlspecialchars($at['nome_profissional']); ?></small>
                                    </td>
                                    <td>
                                        <strong class="text-success">
                                            R$ <?php echo number_format($at['valor_pago'], 2, ',', '.'); ?>
                                        </strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">
                                            <?php echo htmlspecialchars($at['forma_pagamento']); ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Despesas do Dia -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-receipt me-2"></i>
                    Despesas do Dia (<?php echo count($despesas_dia); ?>)
                </h5>
                <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#modalDespesa">
                    <i class="fas fa-plus me-1"></i>
                    Adicionar
                </button>
            </div>
            <div class="card-body">
                <?php if (empty($despesas_dia)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-receipt fa-3x text-muted mb-3"></i>
                        <h6 class="text-muted">Nenhuma despesa registrada</h6>
                        <p class="text-muted">Clique em "Adicionar" para registrar despesas.</p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Descrição</th>
                                    <th>Valor</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($despesas_dia as $desp): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo htmlspecialchars($desp['descricao']); ?></strong>
                                        <br><small class="text-muted">
                                            <?php echo date('H:i', strtotime($desp['data_registro'])); ?>
                                        </small>
                                    </td>
                                    <td>
                                        <strong class="text-danger">
                                            R$ <?php echo number_format($desp['valor'], 2, ',', '.'); ?>
                                        </strong>
                                    </td>
                                    <td>
                                        <a href="editar_despesa.php?id=<?php echo $desp['id_despesa']; ?>" 
                                           class="btn btn-sm btn-outline-warning" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="excluir_despesa.php?id=<?php echo $desp['id_despesa']; ?>" 
                                           class="btn btn-sm btn-outline-danger btn-delete" 
                                           title="Excluir"
                                           data-item="a despesa '<?php echo htmlspecialchars($desp['descricao']); ?>'">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Botão de Fechamento -->
<?php if (!$fechamento_existente && (count($atendimentos_dia) > 0 || count($despesas_dia) > 0)): ?>
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow border-warning">
            <div class="card-body text-center">
                <h5 class="card-title">
                    <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                    Fechamento Pendente
                </h5>
                <p class="card-text">
                    O fechamento do dia ainda não foi realizado. Clique no botão abaixo para processar o fechamento.
                </p>
                <form method="POST" action="" style="display: inline;">
                    <input type="hidden" name="processar_fechamento" value="1">
                    <button type="submit" class="btn btn-warning btn-lg" 
                            onclick="return confirm('Tem certeza que deseja processar o fechamento do dia?')">
                        <i class="fas fa-calculator me-2"></i>
                        Processar Fechamento
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Detalhes do Fechamento -->
<?php if ($fechamento_existente): ?>
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    Detalhes do Fechamento
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Formas de Pagamento -->
                    <div class="col-md-4 mb-3">
                        <h6><i class="fas fa-credit-card me-2"></i>Formas de Pagamento</h6>
                        <?php if (!empty($fechamento_existente['detalhes_pagamento'])): ?>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Forma</th>
                                            <th>Qtd</th>
                                            <th>Valor</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($fechamento_existente['detalhes_pagamento'] as $forma => $dados): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($forma); ?></td>
                                            <td><?php echo $dados['quantidade']; ?></td>
                                            <td>R$ <?php echo number_format($dados['valor'], 2, ',', '.'); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">Nenhum pagamento registrado.</p>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Tipos de Exame -->
                    <div class="col-md-4 mb-3">
                        <h6><i class="fas fa-stethoscope me-2"></i>Tipos de Exame</h6>
                        <?php if (!empty($fechamento_existente['detalhes_exame'])): ?>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Tipo</th>
                                            <th>Qtd</th>
                                            <th>Valor</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($fechamento_existente['detalhes_exame'] as $tipo => $dados): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($tipo); ?></td>
                                            <td><?php echo $dados['quantidade']; ?></td>
                                            <td>R$ <?php echo number_format($dados['valor'], 2, ',', '.'); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">Nenhum exame registrado.</p>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Profissionais -->
                    <div class="col-md-4 mb-3">
                        <h6><i class="fas fa-user-md me-2"></i>Profissionais</h6>
                        <?php if (!empty($fechamento_existente['detalhes_profissionais'])): ?>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Profissional</th>
                                            <th>Atend.</th>
                                            <th>Valor</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($fechamento_existente['detalhes_profissionais'] as $nome => $dados): ?>
                                        <tr>
                                            <td>
                                                <?php echo htmlspecialchars($nome); ?>
                                                <br><small class="text-muted"><?php echo $dados['tipo_registro']; ?></small>
                                            </td>
                                            <td><?php echo $dados['quantidade_atendimentos']; ?></td>
                                            <td>R$ <?php echo number_format($dados['valor_total_atendimentos'], 2, ',', '.'); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">Nenhum profissional registrado.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php else: ?>
<div class="alert alert-warning" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <strong>Atenção!</strong> Selecione uma clínica para visualizar o fechamento diário.
</div>
<?php endif; ?>

<!-- Modal para Adicionar Despesa -->
<div class="modal fade" id="modalDespesa" tabindex="-1" aria-labelledby="modalDespesaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalDespesaLabel">
                    <i class="fas fa-plus me-2"></i>
                    Adicionar Despesa
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="descricao_despesa" class="form-label">Descrição da Despesa</label>
                        <input type="text" class="form-control" id="descricao_despesa" name="descricao_despesa" 
                               placeholder="Ex: Material de escritório, combustível, etc." required>
                    </div>
                    <div class="mb-3">
                        <label for="valor_despesa" class="form-label">Valor</label>
                        <input type="number" class="form-control money-mask" id="valor_despesa" name="valor_despesa" 
                               step="0.01" min="0" placeholder="0,00" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" name="adicionar_despesa" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        Adicionar Despesa
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
