<?php
require_once '../../config/config.php';
require_once '../agendamentos/Agendamento.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

$page_title = 'Agendamentos do Dia';

// Instanciar classes
$agendamento = new Agendamento();
$clinica = new Clinica();

// Obter data selecionada
$data_selecionada = $_GET['data'] ?? date('Y-m-d');

// Obter clínica do usuário (se não for administrador)
$id_clinica_filtro = null;
if ($_SESSION['perfil_acesso'] !== 'Administrador') {
    $id_clinica_filtro = $_SESSION['id_clinica'];
} else {
    $id_clinica_filtro = $_GET['clinica'] ?? null;
}

// Obter dados
$agendamentos_dia = [];
$estatisticas = [];

if ($id_clinica_filtro) {
    $stmt = $agendamento->listarPorData($data_selecionada, $id_clinica_filtro);
    $agendamentos_dia = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $estatisticas = $agendamento->obterEstatisticas($data_selecionada, $data_selecionada, $id_clinica_filtro);
}

// Obter lista de clínicas para administrador
$clinicas = [];
if ($_SESSION['perfil_acesso'] === 'Administrador') {
    $stmt_clinicas = $clinica->listarTodas();
    $clinicas = $stmt_clinicas->fetchAll(PDO::FETCH_ASSOC);
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-calendar-day me-2 text-primary"></i>
                Agendamentos do Dia
            </h1>
            <div class="d-flex gap-2">
                <a href="../agendamentos/agenda.php" class="btn btn-outline-secondary">
                    <i class="fas fa-calendar me-2"></i>
                    Ver Agenda
                </a>
                <button onclick="window.print()" class="btn btn-outline-primary">
                    <i class="fas fa-print me-2"></i>
                    Imprimir
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row align-items-end">
                        <div class="col-md-4">
                            <label for="data" class="form-label">Data</label>
                            <input type="date" class="form-control" id="data" name="data" 
                                   value="<?php echo $data_selecionada; ?>">
                        </div>
                        
                        <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                        <div class="col-md-4">
                            <label for="clinica" class="form-label">Clínica</label>
                            <select class="form-select" id="clinica" name="clinica">
                                <option value="">Todas as clínicas</option>
                                <?php foreach ($clinicas as $clinica_item): ?>
                                    <option value="<?php echo $clinica_item['id_clinica']; ?>" 
                                            <?php echo $id_clinica_filtro == $clinica_item['id_clinica'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-md-4">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>
                                    Consultar
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if ($id_clinica_filtro): ?>
<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Estatísticas - <?php echo date('d/m/Y', strtotime($data_selecionada)); ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo $estatisticas['total_agendamentos'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Total</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo $estatisticas['agendados'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Agendados</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo $estatisticas['presentes'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Presentes</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-danger"><?php echo $estatisticas['faltas'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Faltas</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-secondary"><?php echo $estatisticas['cancelados'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Cancelados</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <?php 
                            $taxa_presenca = 0;
                            if ($estatisticas['total_agendamentos'] > 0) {
                                $taxa_presenca = round(($estatisticas['presentes'] / $estatisticas['total_agendamentos']) * 100, 1);
                            }
                            ?>
                            <h4 class="text-info"><?php echo $taxa_presenca; ?>%</h4>
                            <p class="text-muted mb-0">Taxa Presença</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Lista de Agendamentos -->
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    Lista de Agendamentos (<?php echo count($agendamentos_dia); ?>)
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($agendamentos_dia)): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Nenhum agendamento encontrado</h5>
                        <p class="text-muted">
                            Não há agendamentos para a data selecionada.
                        </p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Horário</th>
                                    <th>Paciente</th>
                                    <th>Contato</th>
                                    <th>Tipo de Exame</th>
                                    <th>Profissional</th>
                                    <th>Status</th>
                                    <th>Observações</th>
                                    <th class="no-print">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($agendamentos_dia as $ag): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo date('H:i', strtotime($ag['data_hora_consulta'])); ?></strong>
                                    </td>
                                    <td>
                                        <strong><?php echo htmlspecialchars($ag['nome_paciente']); ?></strong>
                                        <br><small class="text-muted">
                                            CPF: <?php echo formatarCPF($ag['cpf']); ?>
                                        </small>
                                        <?php if (!empty($ag['renach'])): ?>
                                            <br><small class="text-muted">
                                                RENACH: <?php echo htmlspecialchars($ag['renach']); ?>
                                            </small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if (!empty($ag['telefone_contato'])): ?>
                                            <span class="font-monospace">
                                                <?php echo formatarTelefone($ag['telefone_contato']); ?>
                                            </span>
                                            <br>
                                            <a href="#" onclick="abrirWhatsApp('<?php echo $ag['telefone_contato']; ?>', '<?php echo htmlspecialchars($ag['nome_paciente']); ?>')" 
                                               class="btn btn-sm whatsapp-btn mt-1">
                                                <i class="fab fa-whatsapp me-1"></i>
                                                WhatsApp
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">
                                            <?php echo htmlspecialchars($ag['tipo_exame_agendado']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if (!empty($ag['nome_profissional'])): ?>
                                            <strong><?php echo htmlspecialchars($ag['nome_profissional']); ?></strong>
                                            <br><small class="text-muted">
                                                <?php echo $ag['tipo_registro']; ?>
                                            </small>
                                        <?php else: ?>
                                            <span class="text-muted">Não definido</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge status-<?php echo strtolower($ag['status_atendimento']); ?>">
                                            <?php echo $ag['status_atendimento']; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if (!empty($ag['observacao_agendamento'])): ?>
                                            <small><?php echo htmlspecialchars($ag['observacao_agendamento']); ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="no-print">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="../agendamentos/visualizar.php?id=<?php echo $ag['id_agendamento']; ?>" 
                                               class="btn btn-outline-info" title="Visualizar">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <?php if ($ag['status_atendimento'] === 'Agendado'): ?>
                                                <a href="../agendamentos/marcar_presenca.php?id=<?php echo $ag['id_agendamento']; ?>" 
                                                   class="btn btn-outline-success" title="Marcar Presença">
                                                    <i class="fas fa-check"></i>
                                                </a>
                                                <a href="../agendamentos/marcar_falta.php?id=<?php echo $ag['id_agendamento']; ?>" 
                                                   class="btn btn-outline-danger" title="Marcar Falta">
                                                    <i class="fas fa-times"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Resumo por Status -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <h6>Resumo por Status:</h6>
                            <div class="row">
                                <?php
                                $status_counts = [];
                                foreach ($agendamentos_dia as $ag) {
                                    $status = $ag['status_atendimento'];
                                    $status_counts[$status] = ($status_counts[$status] ?? 0) + 1;
                                }
                                
                                $status_colors = [
                                    'Agendado' => 'warning',
                                    'Presente' => 'success',
                                    'Faltou' => 'danger',
                                    'Cancelado' => 'secondary'
                                ];
                                
                                foreach ($status_counts as $status => $count):
                                    $color = $status_colors[$status] ?? 'primary';
                                ?>
                                <div class="col-md-3 mb-2">
                                    <div class="d-flex align-items-center">
                                        <span class="badge bg-<?php echo $color; ?> me-2"><?php echo $count; ?></span>
                                        <span><?php echo $status; ?></span>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Resumo por Tipo de Exame -->
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>Resumo por Tipo de Exame:</h6>
                            <div class="row">
                                <?php
                                $exame_counts = [];
                                foreach ($agendamentos_dia as $ag) {
                                    $exame = $ag['tipo_exame_agendado'];
                                    $exame_counts[$exame] = ($exame_counts[$exame] ?? 0) + 1;
                                }
                                
                                foreach ($exame_counts as $exame => $count):
                                ?>
                                <div class="col-md-4 mb-2">
                                    <div class="d-flex align-items-center">
                                        <span class="badge bg-info me-2"><?php echo $count; ?></span>
                                        <span><?php echo htmlspecialchars($exame); ?></span>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php else: ?>
<div class="alert alert-warning" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <strong>Atenção!</strong> Selecione uma clínica para visualizar os agendamentos.
</div>
<?php endif; ?>

<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .card-header {
        background-color: #f8f9fa !important;
        color: #000 !important;
        border-bottom: 2px solid #000 !important;
    }
    
    .btn {
        display: none !important;
    }
    
    .navbar {
        display: none !important;
    }
    
    .container-fluid {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .badge {
        border: 1px solid #000 !important;
        color: #000 !important;
        background-color: transparent !important;
    }
}
</style>

<script>
function abrirWhatsApp(telefone, nomePaciente) {
    const mensagem = `Olá ${nomePaciente}, este é um lembrete sobre sua consulta agendada para hoje.`;
    const url = gerarLinkWhatsApp(telefone, mensagem);
    window.open(url, '_blank');
}

// Atualizar automaticamente a cada 2 minutos
setInterval(function() {
    if (!window.matchMedia('print').matches) {
        location.reload();
    }
}, 120000);
</script>

<?php include '../../includes/footer.php'; ?>
