<?php
require_once '../../config/config.php';
require_once '../agendamentos/Agendamento.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

$page_title = 'Agendamentos por Período';

// Instanciar classes
$agendamento = new Agendamento();
$clinica = new Clinica();

// Obter datas selecionadas
$data_inicio = $_GET['data_inicio'] ?? date('Y-m-01'); // Primeiro dia do mês
$data_fim = $_GET['data_fim'] ?? date('Y-m-d'); // Hoje

// Obter clínica do usuário (se não for administrador)
$id_clinica_filtro = null;
if ($_SESSION['perfil_acesso'] !== 'Administrador') {
    $id_clinica_filtro = $_SESSION['id_clinica'];
} else {
    $id_clinica_filtro = $_GET['clinica'] ?? null;
}

// Obter dados
$agendamentos_periodo = [];
$estatisticas = [];

if ($id_clinica_filtro) {
    $stmt = $agendamento->listarPorPeriodo($data_inicio, $data_fim, $id_clinica_filtro);
    $agendamentos_periodo = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $estatisticas = $agendamento->obterEstatisticas($data_inicio, $data_fim, $id_clinica_filtro);
}

// Obter lista de clínicas para administrador
$clinicas = [];
if ($_SESSION['perfil_acesso'] === 'Administrador') {
    $stmt_clinicas = $clinica->listarTodas();
    $clinicas = $stmt_clinicas->fetchAll(PDO::FETCH_ASSOC);
}

// Agrupar agendamentos por data
$agendamentos_por_data = [];
foreach ($agendamentos_periodo as $ag) {
    $data = date('Y-m-d', strtotime($ag['data_hora_consulta']));
    $agendamentos_por_data[$data][] = $ag;
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-calendar-week me-2 text-primary"></i>
                Agendamentos por Período
            </h1>
            <div class="d-flex gap-2">
                <a href="../agendamentos/agenda.php" class="btn btn-outline-secondary">
                    <i class="fas fa-calendar me-2"></i>
                    Ver Agenda
                </a>
                <button onclick="window.print()" class="btn btn-outline-primary">
                    <i class="fas fa-print me-2"></i>
                    Imprimir
                </button>
                <button onclick="exportarExcel()" class="btn btn-outline-success">
                    <i class="fas fa-file-excel me-2"></i>
                    Excel
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row align-items-end">
                        <div class="col-md-3">
                            <label for="data_inicio" class="form-label">Data Início</label>
                            <input type="date" class="form-control" id="data_inicio" name="data_inicio" 
                                   value="<?php echo $data_inicio; ?>">
                        </div>
                        
                        <div class="col-md-3">
                            <label for="data_fim" class="form-label">Data Fim</label>
                            <input type="date" class="form-control" id="data_fim" name="data_fim" 
                                   value="<?php echo $data_fim; ?>">
                        </div>
                        
                        <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                        <div class="col-md-3">
                            <label for="clinica" class="form-label">Clínica</label>
                            <select class="form-select" id="clinica" name="clinica">
                                <option value="">Todas as clínicas</option>
                                <?php foreach ($clinicas as $clinica_item): ?>
                                    <option value="<?php echo $clinica_item['id_clinica']; ?>" 
                                            <?php echo $id_clinica_filtro == $clinica_item['id_clinica'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-md-3">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>
                                    Consultar
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if ($id_clinica_filtro): ?>
<!-- Estatísticas Gerais -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Estatísticas do Período - <?php echo date('d/m/Y', strtotime($data_inicio)); ?> a <?php echo date('d/m/Y', strtotime($data_fim)); ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo $estatisticas['total_agendamentos'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Total</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo $estatisticas['agendados'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Agendados</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo $estatisticas['presentes'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Presentes</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-danger"><?php echo $estatisticas['faltas'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Faltas</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-secondary"><?php echo $estatisticas['cancelados'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Cancelados</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <?php 
                            $taxa_presenca = 0;
                            if ($estatisticas['total_agendamentos'] > 0) {
                                $taxa_presenca = round(($estatisticas['presentes'] / $estatisticas['total_agendamentos']) * 100, 1);
                            }
                            ?>
                            <h4 class="text-info"><?php echo $taxa_presenca; ?>%</h4>
                            <p class="text-muted mb-0">Taxa Presença</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Resumos por Categoria -->
<div class="row mb-4">
    <!-- Resumo por Tipo de Exame -->
    <div class="col-md-6 mb-3">
        <div class="card shadow">
            <div class="card-header bg-success text-white">
                <h6 class="mb-0">
                    <i class="fas fa-stethoscope me-2"></i>
                    Por Tipo de Exame
                </h6>
            </div>
            <div class="card-body">
                <?php
                $exame_counts = [];
                foreach ($agendamentos_periodo as $ag) {
                    $exame = $ag['tipo_exame_agendado'];
                    $exame_counts[$exame] = ($exame_counts[$exame] ?? 0) + 1;
                }
                
                if (!empty($exame_counts)):
                ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Tipo de Exame</th>
                                    <th>Quantidade</th>
                                    <th>%</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($exame_counts as $exame => $count): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($exame); ?></td>
                                    <td><?php echo $count; ?></td>
                                    <td>
                                        <?php echo round(($count / $estatisticas['total_agendamentos']) * 100, 1); ?>%
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted">Nenhum dado disponível.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Resumo por Profissional -->
    <div class="col-md-6 mb-3">
        <div class="card shadow">
            <div class="card-header bg-warning text-dark">
                <h6 class="mb-0">
                    <i class="fas fa-user-md me-2"></i>
                    Por Profissional
                </h6>
            </div>
            <div class="card-body">
                <?php
                $profissional_counts = [];
                foreach ($agendamentos_periodo as $ag) {
                    $prof = $ag['nome_profissional'] ?? 'Não definido';
                    $profissional_counts[$prof] = ($profissional_counts[$prof] ?? 0) + 1;
                }
                
                if (!empty($profissional_counts)):
                ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Profissional</th>
                                    <th>Quantidade</th>
                                    <th>%</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($profissional_counts as $prof => $count): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($prof); ?></td>
                                    <td><?php echo $count; ?></td>
                                    <td>
                                        <?php echo round(($count / $estatisticas['total_agendamentos']) * 100, 1); ?>%
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted">Nenhum dado disponível.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Agendamentos por Data -->
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    Agendamentos por Data (<?php echo count($agendamentos_periodo); ?> total)
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($agendamentos_periodo)): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Nenhum agendamento encontrado</h5>
                        <p class="text-muted">
                            Não há agendamentos para o período selecionado.
                        </p>
                    </div>
                <?php else: ?>
                    <?php foreach ($agendamentos_por_data as $data => $agendamentos_data): ?>
                    <div class="mb-4">
                        <h6 class="border-bottom pb-2">
                            <i class="fas fa-calendar-day me-2"></i>
                            <?php echo date('d/m/Y', strtotime($data)); ?> - 
                            <?php echo ucfirst(strftime('%A', strtotime($data))); ?>
                            <span class="badge bg-primary ms-2"><?php echo count($agendamentos_data); ?> agendamento<?php echo count($agendamentos_data) != 1 ? 's' : ''; ?></span>
                        </h6>
                        
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead>
                                    <tr>
                                        <th>Horário</th>
                                        <th>Paciente</th>
                                        <th>Contato</th>
                                        <th>Tipo de Exame</th>
                                        <th>Profissional</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($agendamentos_data as $ag): ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo date('H:i', strtotime($ag['data_hora_consulta'])); ?></strong>
                                        </td>
                                        <td>
                                            <strong><?php echo htmlspecialchars($ag['nome_paciente']); ?></strong>
                                            <br><small class="text-muted">
                                                CPF: <?php echo formatarCPF($ag['cpf']); ?>
                                            </small>
                                        </td>
                                        <td>
                                            <?php if (!empty($ag['telefone_contato'])): ?>
                                                <span class="font-monospace">
                                                    <?php echo formatarTelefone($ag['telefone_contato']); ?>
                                                </span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                <?php echo htmlspecialchars($ag['tipo_exame_agendado']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if (!empty($ag['nome_profissional'])): ?>
                                                <strong><?php echo htmlspecialchars($ag['nome_profissional']); ?></strong>
                                                <br><small class="text-muted">
                                                    <?php echo $ag['tipo_registro']; ?>
                                                </small>
                                            <?php else: ?>
                                                <span class="text-muted">Não definido</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge status-<?php echo strtolower($ag['status_atendimento']); ?>">
                                                <?php echo $ag['status_atendimento']; ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Resumo do dia -->
                        <div class="row mt-2">
                            <div class="col-12">
                                <small class="text-muted">
                                    Resumo do dia: 
                                    <?php
                                    $status_dia = [];
                                    foreach ($agendamentos_data as $ag) {
                                        $status = $ag['status_atendimento'];
                                        $status_dia[$status] = ($status_dia[$status] ?? 0) + 1;
                                    }
                                    
                                    $resumo_parts = [];
                                    foreach ($status_dia as $status => $count) {
                                        $resumo_parts[] = "$count $status";
                                    }
                                    echo implode(', ', $resumo_parts);
                                    ?>
                                </small>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php else: ?>
<div class="alert alert-warning" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <strong>Atenção!</strong> Selecione uma clínica para visualizar os agendamentos.
</div>
<?php endif; ?>

<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
        page-break-inside: avoid;
    }
    
    .card-header {
        background-color: #f8f9fa !important;
        color: #000 !important;
        border-bottom: 2px solid #000 !important;
    }
    
    .btn {
        display: none !important;
    }
    
    .navbar {
        display: none !important;
    }
    
    .container-fluid {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .table {
        font-size: 11px;
    }
    
    .badge {
        border: 1px solid #000 !important;
        color: #000 !important;
        background-color: transparent !important;
    }
    
    h6 {
        page-break-after: avoid;
    }
    
    .table-responsive {
        page-break-inside: avoid;
    }
}
</style>

<script>
function exportarExcel() {
    // Implementar exportação para Excel
    const tabela = document.querySelector('.table-responsive table');
    if (tabela) {
        const dados = [];
        const linhas = tabela.querySelectorAll('tr');
        
        linhas.forEach(linha => {
            const celulas = linha.querySelectorAll('th, td');
            const linhaDados = [];
            celulas.forEach(celula => {
                linhaDados.push(celula.textContent.trim());
            });
            dados.push(linhaDados);
        });
        
        // Aqui você pode implementar a exportação real para Excel
        // Por enquanto, apenas mostra um alerta
        mostrarToast('Exportação', 'Funcionalidade de exportação para Excel será implementada em breve.', 'info');
    }
}

// Atalhos de teclado
document.addEventListener('keydown', function(e) {
    if (e.ctrlKey && e.key === 'p') {
        e.preventDefault();
        window.print();
    }
    
    if (e.ctrlKey && e.key === 'e') {
        e.preventDefault();
        exportarExcel();
    }
});
</script>

<?php include '../../includes/footer.php'; ?>
