<?php
require_once '../../config/config.php';
require_once '../financeiro/FechamentoDiario.php';
require_once '../atendimentos/Atendimento.php';
require_once '../financeiro/DespesaDiaria.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

$page_title = 'Relatório Financeiro';

// Instanciar classes
$fechamento = new FechamentoDiario();
$atendimento = new Atendimento();
$despesa = new DespesaDiaria();
$clinica = new Clinica();

// Obter datas selecionadas
$data_inicio = $_GET['data_inicio'] ?? date('Y-m-01'); // Primeiro dia do mês
$data_fim = $_GET['data_fim'] ?? date('Y-m-d'); // Hoje
$tipo_relatorio = $_GET['tipo'] ?? 'resumo'; // resumo, detalhado, comparativo

// Obter clínica do usuário (se não for administrador)
$id_clinica_filtro = null;
if ($_SESSION['perfil_acesso'] !== 'Administrador') {
    $id_clinica_filtro = $_SESSION['id_clinica'];
} else {
    $id_clinica_filtro = $_GET['clinica'] ?? null;
}

// Obter dados
$resumo_periodo = [];
$fechamentos_periodo = [];
$estatisticas_atendimentos = [];
$estatisticas_despesas = [];

if ($id_clinica_filtro) {
    // Resumo do período
    $resumo_periodo = $fechamento->obterResumoPeriodo($data_inicio, $data_fim, $id_clinica_filtro);
    
    // Fechamentos do período
    $stmt_fechamentos = $fechamento->listarPorPeriodo($data_inicio, $data_fim, $id_clinica_filtro);
    $fechamentos_periodo = $stmt_fechamentos->fetchAll(PDO::FETCH_ASSOC);
    
    // Estatísticas de atendimentos
    $estatisticas_atendimentos = $atendimento->obterEstatisticas($data_inicio, $data_fim, $id_clinica_filtro);
    
    // Estatísticas de despesas
    $estatisticas_despesas = $despesa->obterTotalPorPeriodo($data_inicio, $data_fim, $id_clinica_filtro);
}

// Obter lista de clínicas para administrador
$clinicas = [];
if ($_SESSION['perfil_acesso'] === 'Administrador') {
    $stmt_clinicas = $clinica->listarTodas();
    $clinicas = $stmt_clinicas->fetchAll(PDO::FETCH_ASSOC);
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-chart-line me-2 text-success"></i>
                Relatório Financeiro
            </h1>
            <div class="d-flex gap-2">
                <a href="../financeiro/fechamento.php" class="btn btn-outline-secondary">
                    <i class="fas fa-calculator me-2"></i>
                    Fechamento
                </a>
                <button onclick="window.print()" class="btn btn-outline-primary">
                    <i class="fas fa-print me-2"></i>
                    Imprimir
                </button>
                <button onclick="exportarPDF()" class="btn btn-outline-danger">
                    <i class="fas fa-file-pdf me-2"></i>
                    PDF
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row align-items-end">
                        <div class="col-md-2">
                            <label for="data_inicio" class="form-label">Data Início</label>
                            <input type="date" class="form-control" id="data_inicio" name="data_inicio" 
                                   value="<?php echo $data_inicio; ?>">
                        </div>
                        
                        <div class="col-md-2">
                            <label for="data_fim" class="form-label">Data Fim</label>
                            <input type="date" class="form-control" id="data_fim" name="data_fim" 
                                   value="<?php echo $data_fim; ?>">
                        </div>
                        
                        <div class="col-md-2">
                            <label for="tipo" class="form-label">Tipo de Relatório</label>
                            <select class="form-select" id="tipo" name="tipo">
                                <option value="resumo" <?php echo $tipo_relatorio == 'resumo' ? 'selected' : ''; ?>>
                                    Resumo
                                </option>
                                <option value="detalhado" <?php echo $tipo_relatorio == 'detalhado' ? 'selected' : ''; ?>>
                                    Detalhado
                                </option>
                                <option value="comparativo" <?php echo $tipo_relatorio == 'comparativo' ? 'selected' : ''; ?>>
                                    Comparativo
                                </option>
                            </select>
                        </div>
                        
                        <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                        <div class="col-md-3">
                            <label for="clinica" class="form-label">Clínica</label>
                            <select class="form-select" id="clinica" name="clinica">
                                <option value="">Todas as clínicas</option>
                                <?php foreach ($clinicas as $clinica_item): ?>
                                    <option value="<?php echo $clinica_item['id_clinica']; ?>" 
                                            <?php echo $id_clinica_filtro == $clinica_item['id_clinica'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-md-3">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>
                                    Gerar Relatório
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if ($id_clinica_filtro): ?>
<!-- Resumo Executivo -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    Resumo Executivo - <?php echo date('d/m/Y', strtotime($data_inicio)); ?> a <?php echo date('d/m/Y', strtotime($data_fim)); ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-success">
                                R$ <?php echo number_format($resumo_periodo['total_recebido_periodo'] ?? 0, 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Total Recebido</p>
                            <small class="text-muted">
                                <?php echo $estatisticas_atendimentos['total_atendimentos'] ?? 0; ?> atendimentos
                            </small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-danger">
                                R$ <?php echo number_format($resumo_periodo['total_despesas_periodo'] ?? 0, 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Total Despesas</p>
                            <small class="text-muted">
                                <?php echo $estatisticas_despesas['total_despesas'] ?? 0; ?> lançamentos
                            </small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <?php 
                            $saldo_periodo = ($resumo_periodo['total_recebido_periodo'] ?? 0) - ($resumo_periodo['total_despesas_periodo'] ?? 0);
                            $cor_saldo = $saldo_periodo >= 0 ? 'text-success' : 'text-danger';
                            ?>
                            <h4 class="<?php echo $cor_saldo; ?>">
                                R$ <?php echo number_format($saldo_periodo, 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Saldo Período</p>
                            <small class="text-muted">
                                <?php echo $saldo_periodo >= 0 ? 'Lucro' : 'Prejuízo'; ?>
                            </small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-info">
                                R$ <?php echo number_format($estatisticas_atendimentos['ticket_medio'] ?? 0, 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Ticket Médio</p>
                            <small class="text-muted">Por atendimento</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-warning">
                                R$ <?php echo number_format($resumo_periodo['media_recebido_dia'] ?? 0, 2, ',', '.'); ?>
                            </h4>
                            <p class="text-muted mb-0">Média Diária</p>
                            <small class="text-muted">Receita por dia</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-primary">
                                <?php echo $resumo_periodo['dias_fechados'] ?? 0; ?>
                            </h4>
                            <p class="text-muted mb-0">Dias Fechados</p>
                            <small class="text-muted">No período</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($tipo_relatorio == 'resumo' || $tipo_relatorio == 'detalhado'): ?>
<!-- Gráfico de Evolução -->
<div class="row mb-4">
    <div class="col-md-8">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0">
                    <i class="fas fa-chart-line me-2"></i>
                    Evolução Diária
                </h6>
            </div>
            <div class="card-body">
                <canvas id="graficoEvolucao" height="300"></canvas>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card shadow">
            <div class="card-header bg-warning text-dark">
                <h6 class="mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    Distribuição
                </h6>
            </div>
            <div class="card-body">
                <canvas id="graficoDistribuicao" height="300"></canvas>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if ($tipo_relatorio == 'detalhado'): ?>
<!-- Fechamentos Detalhados -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    Fechamentos Detalhados (<?php echo count($fechamentos_periodo); ?>)
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($fechamentos_periodo)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Nenhum fechamento encontrado</h5>
                        <p class="text-muted">
                            Não há fechamentos para o período selecionado.
                        </p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Data</th>
                                    <th>Total Recebido</th>
                                    <th>Total Despesas</th>
                                    <th>Saldo</th>
                                    <th>Formas Pagamento</th>
                                    <th>Tipos Exame</th>
                                    <th class="no-print">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($fechamentos_periodo as $fech): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo date('d/m/Y', strtotime($fech['data_fechamento'])); ?></strong>
                                        <br><small class="text-muted">
                                            <?php echo ucfirst(strftime('%A', strtotime($fech['data_fechamento']))); ?>
                                        </small>
                                    </td>
                                    <td>
                                        <strong class="text-success">
                                            R$ <?php echo number_format($fech['total_recebido'], 2, ',', '.'); ?>
                                        </strong>
                                    </td>
                                    <td>
                                        <strong class="text-danger">
                                            R$ <?php echo number_format($fech['total_despesas'], 2, ',', '.'); ?>
                                        </strong>
                                    </td>
                                    <td>
                                        <?php 
                                        $cor_saldo = $fech['saldo_dia'] >= 0 ? 'text-success' : 'text-danger';
                                        ?>
                                        <strong class="<?php echo $cor_saldo; ?>">
                                            R$ <?php echo number_format($fech['saldo_dia'], 2, ',', '.'); ?>
                                        </strong>
                                    </td>
                                    <td>
                                        <?php 
                                        $detalhes_pagamento = json_decode($fech['detalhes_pagamento'], true);
                                        if ($detalhes_pagamento):
                                            foreach ($detalhes_pagamento as $forma => $dados):
                                        ?>
                                            <small class="d-block">
                                                <span class="badge bg-info"><?php echo $dados['quantidade']; ?></span>
                                                <?php echo $forma; ?>: R$ <?php echo number_format($dados['valor'], 2, ',', '.'); ?>
                                            </small>
                                        <?php 
                                            endforeach;
                                        else:
                                        ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php 
                                        $detalhes_exame = json_decode($fech['detalhes_exame'], true);
                                        if ($detalhes_exame):
                                            foreach ($detalhes_exame as $tipo => $dados):
                                        ?>
                                            <small class="d-block">
                                                <span class="badge bg-success"><?php echo $dados['quantidade']; ?></span>
                                                <?php echo $tipo; ?>
                                            </small>
                                        <?php 
                                            endforeach;
                                        else:
                                        ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="no-print">
                                        <a href="../financeiro/fechamento.php?data=<?php echo $fech['data_fechamento']; ?>&clinica=<?php echo $fech['id_clinica']; ?>" 
                                           class="btn btn-sm btn-outline-info" title="Ver Fechamento">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <th>TOTAL</th>
                                    <th>
                                        R$ <?php echo number_format($resumo_periodo['total_recebido_periodo'] ?? 0, 2, ',', '.'); ?>
                                    </th>
                                    <th>
                                        R$ <?php echo number_format($resumo_periodo['total_despesas_periodo'] ?? 0, 2, ',', '.'); ?>
                                    </th>
                                    <th class="<?php echo $saldo_periodo >= 0 ? 'text-success' : 'text-danger'; ?>">
                                        R$ <?php echo number_format($saldo_periodo, 2, ',', '.'); ?>
                                    </th>
                                    <th colspan="3"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if ($tipo_relatorio == 'comparativo'): ?>
<!-- Análise Comparativa -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Comparativo Mensal
                </h6>
            </div>
            <div class="card-body">
                <canvas id="graficoComparativo" height="300"></canvas>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card shadow">
            <div class="card-header bg-warning text-dark">
                <h6 class="mb-0">
                    <i class="fas fa-trophy me-2"></i>
                    Melhores Dias
                </h6>
            </div>
            <div class="card-body">
                <?php 
                $melhores_dias = $fechamento->obterMelhoresDias(5, $data_inicio, $data_fim, $id_clinica_filtro);
                ?>
                
                <?php if (!empty($melhores_dias)): ?>
                    <div class="list-group">
                        <?php foreach ($melhores_dias as $index => $dia): ?>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">
                                    <?php if ($index == 0): ?>
                                        <i class="fas fa-crown text-warning me-1"></i>
                                    <?php endif; ?>
                                    <?php echo date('d/m/Y', strtotime($dia['data_fechamento'])); ?>
                                </h6>
                                <small class="text-muted">
                                    Receita: R$ <?php echo number_format($dia['total_recebido'], 2, ',', '.'); ?> | 
                                    Despesas: R$ <?php echo number_format($dia['total_despesas'], 2, ',', '.'); ?>
                                </small>
                            </div>
                            <span class="badge bg-success rounded-pill">
                                R$ <?php echo number_format($dia['saldo_dia'], 2, ',', '.'); ?>
                            </span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="text-muted">Nenhum dado disponível para comparação.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Indicadores de Performance -->
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-dark text-white">
                <h5 class="mb-0">
                    <i class="fas fa-tachometer-alt me-2"></i>
                    Indicadores de Performance
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <?php 
                            $margem_lucro = 0;
                            if ($resumo_periodo['total_recebido_periodo'] > 0) {
                                $margem_lucro = round(($saldo_periodo / $resumo_periodo['total_recebido_periodo']) * 100, 1);
                            }
                            $cor_margem = $margem_lucro >= 20 ? 'text-success' : ($margem_lucro >= 10 ? 'text-warning' : 'text-danger');
                            ?>
                            <h4 class="<?php echo $cor_margem; ?>"><?php echo $margem_lucro; ?>%</h4>
                            <p class="text-muted mb-0">Margem de Lucro</p>
                            <small class="text-muted">
                                <?php 
                                if ($margem_lucro >= 20) echo 'Excelente';
                                elseif ($margem_lucro >= 10) echo 'Boa';
                                else echo 'Atenção';
                                ?>
                            </small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <?php 
                            $crescimento = 0; // Aqui você pode calcular o crescimento comparando com período anterior
                            ?>
                            <h4 class="text-info"><?php echo $crescimento; ?>%</h4>
                            <p class="text-muted mb-0">Crescimento</p>
                            <small class="text-muted">vs. período anterior</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary">
                                <?php echo $estatisticas_atendimentos['pacientes_unicos'] ?? 0; ?>
                            </h4>
                            <p class="text-muted mb-0">Pacientes Únicos</p>
                            <small class="text-muted">No período</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-secondary">
                                <?php echo $estatisticas_atendimentos['profissionais_ativos'] ?? 0; ?>
                            </h4>
                            <p class="text-muted mb-0">Profissionais Ativos</p>
                            <small class="text-muted">No período</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php else: ?>
<div class="alert alert-warning" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <strong>Atenção!</strong> Selecione uma clínica para visualizar o relatório financeiro.
</div>
<?php endif; ?>

<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
        page-break-inside: avoid;
    }
    
    .card-header {
        background-color: #f8f9fa !important;
        color: #000 !important;
        border-bottom: 2px solid #000 !important;
    }
    
    .btn {
        display: none !important;
    }
    
    .navbar {
        display: none !important;
    }
    
    .container-fluid {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .table {
        font-size: 11px;
    }
    
    .badge {
        border: 1px solid #000 !important;
        color: #000 !important;
        background-color: transparent !important;
    }
    
    canvas {
        display: none !important;
    }
}
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Dados para os gráficos
const dadosFinanceiros = <?php echo json_encode($fechamentos_periodo); ?>;

// Gráfico de Evolução Diária
if (document.getElementById('graficoEvolucao')) {
    const ctx1 = document.getElementById('graficoEvolucao').getContext('2d');
    
    const labels = dadosFinanceiros.map(item => {
        const data = new Date(item.data_fechamento);
        return data.toLocaleDateString('pt-BR', {day: '2-digit', month: '2-digit'});
    });
    
    const receitas = dadosFinanceiros.map(item => parseFloat(item.total_recebido));
    const despesas = dadosFinanceiros.map(item => parseFloat(item.total_despesas));
    const saldos = dadosFinanceiros.map(item => parseFloat(item.saldo_dia));
    
    new Chart(ctx1, {
        type: 'line',
        data: {
            labels: labels,
            datasets: [{
                label: 'Receitas',
                data: receitas,
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                tension: 0.1
            }, {
                label: 'Despesas',
                data: despesas,
                borderColor: 'rgb(255, 99, 132)',
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                tension: 0.1
            }, {
                label: 'Saldo',
                data: saldos,
                borderColor: 'rgb(54, 162, 235)',
                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                tension: 0.1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'R$ ' + value.toLocaleString('pt-BR');
                        }
                    }
                }
            }
        }
    });
}

// Gráfico de Distribuição
if (document.getElementById('graficoDistribuicao')) {
    const ctx2 = document.getElementById('graficoDistribuicao').getContext('2d');
    
    const totalReceitas = <?php echo $resumo_periodo['total_recebido_periodo'] ?? 0; ?>;
    const totalDespesas = <?php echo $resumo_periodo['total_despesas_periodo'] ?? 0; ?>;
    
    new Chart(ctx2, {
        type: 'doughnut',
        data: {
            labels: ['Receitas', 'Despesas'],
            datasets: [{
                data: [totalReceitas, totalDespesas],
                backgroundColor: [
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(255, 99, 132, 0.8)'
                ],
                borderColor: [
                    'rgb(75, 192, 192)',
                    'rgb(255, 99, 132)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
}

function exportarPDF() {
    window.print();
}
</script>

<?php include '../../includes/footer.php'; ?>
