<?php
require_once '../../config/config.php';
require_once 'Usuario.php';

verificarLogin();

// Verificar se tem permissão (apenas Administrador e Gerente)
if (!in_array($_SESSION['perfil_acesso'], ['Administrador', 'Gerente'])) {
    header('Location: ../../dashboard.php?erro=sem_permissao');
    exit;
}

$id_usuario = $_GET['id'] ?? null;
$acao = $_GET['acao'] ?? null;

if (empty($id_usuario) || empty($acao)) {
    header('Location: listar.php?erro=parametros_invalidos');
    exit;
}

if (!in_array($acao, ['ativar', 'desativar'])) {
    header('Location: listar.php?erro=acao_invalida');
    exit;
}

try {
    $usuario = new Usuario();
    $usuario->id_usuario = $id_usuario;
    
    // Verificar se o usuário existe
    $dados_usuario = $usuario->lerUm();
    if (!$dados_usuario) {
        header('Location: listar.php?erro=usuario_nao_encontrado');
        exit;
    }
    
    // Verificar permissões específicas
    if ($_SESSION['perfil_acesso'] === 'Gerente') {
        // Gerente só pode alterar status de secretárias da sua clínica
        if ($dados_usuario['perfil_acesso'] !== 'Secretaria' || 
            $dados_usuario['id_clinica'] != $_SESSION['id_clinica']) {
            header('Location: listar.php?erro=sem_permissao_usuario');
            exit;
        }
    }
    
    // Não permitir que o usuário desative a si mesmo
    if ($id_usuario == $_SESSION['id_usuario'] && $acao === 'desativar') {
        header('Location: listar.php?erro=nao_pode_desativar_proprio');
        exit;
    }
    
    // Alterar status
    $novo_status = ($acao === 'ativar') ? true : false;
    
    if ($usuario->alterarStatus($novo_status)) {
        $mensagem = $acao === 'ativar' ? 'ativado' : 'desativado';
        header('Location: listar.php?sucesso=usuario_' . $mensagem);
    } else {
        header('Location: listar.php?erro=erro_alterar_status');
    }
    
} catch (Exception $e) {
    error_log("Erro ao alterar status do usuário: " . $e->getMessage());
    header('Location: listar.php?erro=erro_interno');
}
?>
