<?php
require_once '../../config/config.php';
require_once 'Usuario.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

// Verificar se tem permissão (apenas Administrador)
if ($_SESSION['perfil_acesso'] !== 'Administrador') {
    header('Location: ../../dashboard.php?erro=sem_permissao');
    exit;
}

$page_title = 'Cadastrar Usuário';

$erro = '';
$sucesso = '';

// Instanciar classes
$usuario = new Usuario();
$clinica = new Clinica();

// Obter lista de clínicas
$stmt_clinicas = $clinica->listarTodas();
$clinicas = $stmt_clinicas->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome_usuario = $_POST['nome_usuario'] ?? '';
    $email = $_POST['email'] ?? '';
    $senha = $_POST['senha'] ?? '';
    $confirmar_senha = $_POST['confirmar_senha'] ?? '';
    $perfil_acesso = $_POST['perfil_acesso'] ?? '';
    $id_clinica = $_POST['id_clinica'] ?? null;
    $ativo = isset($_POST['ativo']) ? 1 : 0;
    
    // Validações
    if (empty($nome_usuario)) {
        $erro = 'O nome do usuário é obrigatório.';
    } elseif (empty($email)) {
        $erro = 'O email é obrigatório.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $erro = 'Email inválido.';
    } elseif (empty($senha)) {
        $erro = 'A senha é obrigatória.';
    } elseif (strlen($senha) < 6) {
        $erro = 'A senha deve ter pelo menos 6 caracteres.';
    } elseif ($senha !== $confirmar_senha) {
        $erro = 'As senhas não coincidem.';
    } elseif (empty($perfil_acesso)) {
        $erro = 'Selecione um perfil de acesso.';
    } elseif ($perfil_acesso !== 'Administrador' && empty($id_clinica)) {
        $erro = 'Selecione uma clínica para usuários não administradores.';
    } else {
        // Verificar se email já existe
        if ($usuario->emailExiste($email)) {
            $erro = 'Este email já está cadastrado no sistema.';
        } else {
            // Criar usuário
            $usuario->nome_usuario = $nome_usuario;
            $usuario->email = $email;
            $usuario->senha = $senha;
            $usuario->perfil_acesso = $perfil_acesso;
            $usuario->id_clinica = $perfil_acesso === 'Administrador' ? null : $id_clinica;
            $usuario->ativo = $ativo;
            
            if ($usuario->criar()) {
                $sucesso = 'Usuário cadastrado com sucesso!';
                // Limpar campos
                $nome_usuario = $email = $senha = $confirmar_senha = $perfil_acesso = $id_clinica = '';
                $ativo = 1;
            } else {
                $erro = 'Erro ao cadastrar usuário. Tente novamente.';
            }
        }
    }
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-user-plus me-2 text-primary"></i>
                Cadastrar Usuário
            </h1>
            <a href="listar.php" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>
                Voltar à Lista
            </a>
        </div>
    </div>
</div>

<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-user-cog me-2"></i>
                    Dados do Usuário
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($erro)): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <?php echo $erro; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($sucesso)): ?>
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        <?php echo $sucesso; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" action="" novalidate>
                    <!-- Informações Pessoais -->
                    <div class="card mb-4">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0">
                                <i class="fas fa-user me-2"></i>
                                Informações Pessoais
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nome_usuario" class="form-label">
                                        <i class="fas fa-user me-1"></i>
                                        Nome Completo <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nome_usuario" name="nome_usuario" 
                                           value="<?php echo htmlspecialchars($nome_usuario ?? ''); ?>" 
                                           placeholder="Digite o nome completo" required>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">
                                        <i class="fas fa-envelope me-1"></i>
                                        Email <span class="text-danger">*</span>
                                    </label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?php echo htmlspecialchars($email ?? ''); ?>" 
                                           placeholder="usuario@exemplo.com" required>
                                    <div class="form-text">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Este email será usado para login no sistema.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Credenciais de Acesso -->
                    <div class="card mb-4">
                        <div class="card-header bg-warning text-dark">
                            <h6 class="mb-0">
                                <i class="fas fa-key me-2"></i>
                                Credenciais de Acesso
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="senha" class="form-label">
                                        <i class="fas fa-lock me-1"></i>
                                        Senha <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="senha" name="senha" 
                                               placeholder="Mínimo 6 caracteres" required>
                                        <button class="btn btn-outline-secondary" type="button" onclick="toggleSenha('senha')">
                                            <i class="fas fa-eye" id="iconSenha"></i>
                                        </button>
                                    </div>
                                    <div class="form-text">
                                        <i class="fas fa-shield-alt me-1"></i>
                                        Use uma senha forte com pelo menos 6 caracteres.
                                    </div>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="confirmar_senha" class="form-label">
                                        <i class="fas fa-lock me-1"></i>
                                        Confirmar Senha <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="confirmar_senha" name="confirmar_senha" 
                                               placeholder="Digite a senha novamente" required>
                                        <button class="btn btn-outline-secondary" type="button" onclick="toggleSenha('confirmar_senha')">
                                            <i class="fas fa-eye" id="iconConfirmarSenha"></i>
                                        </button>
                                    </div>
                                    <div id="senhaMatch" class="form-text"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Permissões e Acesso -->
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0">
                                <i class="fas fa-shield-alt me-2"></i>
                                Permissões e Acesso
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="perfil_acesso" class="form-label">
                                        <i class="fas fa-user-tag me-1"></i>
                                        Perfil de Acesso <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="perfil_acesso" name="perfil_acesso" required>
                                        <option value="">Selecione um perfil</option>
                                        <option value="Administrador" <?php echo ($perfil_acesso ?? '') == 'Administrador' ? 'selected' : ''; ?>>
                                            Administrador - Acesso total ao sistema
                                        </option>
                                        <option value="Gerente" <?php echo ($perfil_acesso ?? '') == 'Gerente' ? 'selected' : ''; ?>>
                                            Gerente - Gerencia uma clínica específica
                                        </option>
                                        <option value="Secretaria" <?php echo ($perfil_acesso ?? '') == 'Secretaria' ? 'selected' : ''; ?>>
                                            Secretária - Operações básicas da clínica
                                        </option>
                                    </select>
                                </div>
                                
                                <div class="col-md-6 mb-3" id="clinicaField">
                                    <label for="id_clinica" class="form-label">
                                        <i class="fas fa-building me-1"></i>
                                        Clínica <span class="text-danger" id="clinicaRequired">*</span>
                                    </label>
                                    <select class="form-select" id="id_clinica" name="id_clinica">
                                        <option value="">Selecione uma clínica</option>
                                        <?php foreach ($clinicas as $clinica_item): ?>
                                            <option value="<?php echo $clinica_item['id_clinica']; ?>" 
                                                    <?php echo ($id_clinica ?? '') == $clinica_item['id_clinica'] ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <div class="form-text">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Administradores têm acesso a todas as clínicas.
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="ativo" name="ativo" 
                                               <?php echo ($ativo ?? 1) ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="ativo">
                                            <i class="fas fa-user-check me-1"></i>
                                            Usuário ativo
                                        </label>
                                        <div class="form-text">
                                            <i class="fas fa-info-circle me-1"></i>
                                            Usuários inativos não conseguem fazer login no sistema.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="listar.php" class="btn btn-outline-secondary me-md-2">
                                    <i class="fas fa-times me-2"></i>
                                    Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-2"></i>
                                    Cadastrar Usuário
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Informações sobre Perfis -->
<div class="row mt-4">
    <div class="col-lg-8 mx-auto">
        <div class="card shadow">
            <div class="card-header bg-dark text-white">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informações sobre Perfis de Acesso
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <h6><i class="fas fa-crown text-warning me-2"></i>Administrador</h6>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i>Acesso total ao sistema</li>
                            <li><i class="fas fa-check text-success me-2"></i>Gerencia todas as clínicas</li>
                            <li><i class="fas fa-check text-success me-2"></i>Cadastra usuários</li>
                            <li><i class="fas fa-check text-success me-2"></i>Relatórios completos</li>
                        </ul>
                    </div>
                    <div class="col-md-4">
                        <h6><i class="fas fa-user-tie text-info me-2"></i>Gerente</h6>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i>Gerencia uma clínica</li>
                            <li><i class="fas fa-check text-success me-2"></i>Cadastra secretárias</li>
                            <li><i class="fas fa-check text-success me-2"></i>Relatórios da clínica</li>
                            <li><i class="fas fa-check text-success me-2"></i>Fechamento financeiro</li>
                        </ul>
                    </div>
                    <div class="col-md-4">
                        <h6><i class="fas fa-user text-secondary me-2"></i>Secretária</h6>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i>Agenda de atendimentos</li>
                            <li><i class="fas fa-check text-success me-2"></i>Cadastro de pacientes</li>
                            <li><i class="fas fa-check text-success me-2"></i>Relatórios básicos</li>
                            <li><i class="fas fa-times text-danger me-2"></i>Sem acesso financeiro</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function toggleSenha(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = document.getElementById('icon' + fieldId.charAt(0).toUpperCase() + fieldId.slice(1));
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.className = 'fas fa-eye-slash';
    } else {
        field.type = 'password';
        icon.className = 'fas fa-eye';
    }
}

// Controlar exibição do campo clínica baseado no perfil
document.getElementById('perfil_acesso').addEventListener('change', function() {
    const clinicaField = document.getElementById('clinicaField');
    const clinicaSelect = document.getElementById('id_clinica');
    const clinicaRequired = document.getElementById('clinicaRequired');
    
    if (this.value === 'Administrador') {
        clinicaField.style.display = 'none';
        clinicaSelect.required = false;
        clinicaRequired.style.display = 'none';
        clinicaSelect.value = '';
    } else {
        clinicaField.style.display = 'block';
        clinicaSelect.required = true;
        clinicaRequired.style.display = 'inline';
    }
});

// Verificar se as senhas coincidem
document.getElementById('confirmar_senha').addEventListener('input', function() {
    const senha = document.getElementById('senha').value;
    const confirmarSenha = this.value;
    const senhaMatch = document.getElementById('senhaMatch');
    
    if (confirmarSenha === '') {
        senhaMatch.innerHTML = '';
        this.classList.remove('is-valid', 'is-invalid');
    } else if (senha === confirmarSenha) {
        senhaMatch.innerHTML = '<i class="fas fa-check text-success me-1"></i>Senhas coincidem';
        this.classList.remove('is-invalid');
        this.classList.add('is-valid');
    } else {
        senhaMatch.innerHTML = '<i class="fas fa-times text-danger me-1"></i>Senhas não coincidem';
        this.classList.remove('is-valid');
        this.classList.add('is-invalid');
    }
});

// Validação de força da senha
document.getElementById('senha').addEventListener('input', function() {
    const senha = this.value;
    const senhaField = this;
    
    if (senha.length === 0) {
        senhaField.classList.remove('is-valid', 'is-invalid');
    } else if (senha.length < 6) {
        senhaField.classList.remove('is-valid');
        senhaField.classList.add('is-invalid');
    } else {
        senhaField.classList.remove('is-invalid');
        senhaField.classList.add('is-valid');
    }
    
    // Verificar novamente a confirmação
    const confirmarSenha = document.getElementById('confirmar_senha');
    if (confirmarSenha.value !== '') {
        confirmarSenha.dispatchEvent(new Event('input'));
    }
});

// Validação de email
document.getElementById('email').addEventListener('blur', function() {
    const email = this.value;
    const emailField = this;
    
    if (email === '') {
        emailField.classList.remove('is-valid', 'is-invalid');
    } else if (validateEmail(email)) {
        emailField.classList.remove('is-invalid');
        emailField.classList.add('is-valid');
    } else {
        emailField.classList.remove('is-valid');
        emailField.classList.add('is-invalid');
    }
});

function validateEmail(email) {
    const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return re.test(email);
}

// Inicializar estado do campo clínica
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('perfil_acesso').dispatchEvent(new Event('change'));
});
</script>

<?php include '../../includes/footer.php'; ?>
