<?php
require_once '../../config/config.php';
require_once 'Usuario.php';
require_once '../clinicas/Clinica.php';

verificarLogin();

// Verificar se tem permissão (apenas Administrador e Gerente)
if (!in_array($_SESSION['perfil_acesso'], ['Administrador', 'Gerente'])) {
    header('Location: ../../dashboard.php?erro=sem_permissao');
    exit;
}

$page_title = 'Usuários do Sistema';

// Instanciar classes
$usuario = new Usuario();
$clinica = new Clinica();

// Obter filtros
$busca = $_GET['busca'] ?? '';
$perfil_filtro = $_GET['perfil'] ?? '';
$status_filtro = $_GET['status'] ?? '';

// Obter clínica do usuário (se não for administrador)
$id_clinica_filtro = null;
if ($_SESSION['perfil_acesso'] !== 'Administrador') {
    $id_clinica_filtro = $_SESSION['id_clinica'];
} else {
    $id_clinica_filtro = $_GET['clinica'] ?? null;
}

// Obter dados
$usuarios = [];
$estatisticas = [];

if (!empty($busca)) {
    $stmt = $usuario->buscar($busca, $id_clinica_filtro);
} else {
    $stmt = $usuario->listarTodos($id_clinica_filtro);
}

$usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Aplicar filtros adicionais
if (!empty($perfil_filtro) || !empty($status_filtro)) {
    $usuarios = array_filter($usuarios, function($user) use ($perfil_filtro, $status_filtro) {
        $perfil_ok = empty($perfil_filtro) || $user['perfil_acesso'] == $perfil_filtro;
        $status_ok = empty($status_filtro) || 
                     ($status_filtro == 'ativo' && $user['ativo'] == 1) ||
                     ($status_filtro == 'inativo' && $user['ativo'] == 0);
        
        return $perfil_ok && $status_ok;
    });
}

// Obter estatísticas
$estatisticas = $usuario->obterEstatisticas($id_clinica_filtro);

// Obter lista de clínicas para administrador
$clinicas = [];
if ($_SESSION['perfil_acesso'] === 'Administrador') {
    $stmt_clinicas = $clinica->listarTodas();
    $clinicas = $stmt_clinicas->fetchAll(PDO::FETCH_ASSOC);
}

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">
                <i class="fas fa-users me-2 text-primary"></i>
                Usuários do Sistema
            </h1>
            <div class="d-flex gap-2">
                <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                <a href="cadastrar.php" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>
                    Novo Usuário
                </a>
                <?php endif; ?>
                <button onclick="window.print()" class="btn btn-outline-secondary">
                    <i class="fas fa-print me-2"></i>
                    Imprimir
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Estatísticas de Usuários
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo $estatisticas['total_usuarios'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Total</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo $estatisticas['usuarios_ativos'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Ativos</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-danger"><?php echo $estatisticas['usuarios_inativos'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Inativos</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo $estatisticas['administradores'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Administradores</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-info"><?php echo $estatisticas['gerentes'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Gerentes</p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h4 class="text-secondary"><?php echo $estatisticas['secretarias'] ?? 0; ?></h4>
                            <p class="text-muted mb-0">Secretárias</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row align-items-end">
                        <div class="col-md-3">
                            <label for="busca" class="form-label">Buscar</label>
                            <input type="text" class="form-control" id="busca" name="busca" 
                                   value="<?php echo htmlspecialchars($busca); ?>" 
                                   placeholder="Nome ou email do usuário">
                        </div>
                        
                        <div class="col-md-2">
                            <label for="perfil" class="form-label">Perfil</label>
                            <select class="form-select" id="perfil" name="perfil">
                                <option value="">Todos os perfis</option>
                                <option value="Administrador" <?php echo $perfil_filtro == 'Administrador' ? 'selected' : ''; ?>>
                                    Administrador
                                </option>
                                <option value="Gerente" <?php echo $perfil_filtro == 'Gerente' ? 'selected' : ''; ?>>
                                    Gerente
                                </option>
                                <option value="Secretaria" <?php echo $perfil_filtro == 'Secretaria' ? 'selected' : ''; ?>>
                                    Secretária
                                </option>
                            </select>
                        </div>
                        
                        <div class="col-md-2">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" id="status" name="status">
                                <option value="">Todos</option>
                                <option value="ativo" <?php echo $status_filtro == 'ativo' ? 'selected' : ''; ?>>
                                    Ativo
                                </option>
                                <option value="inativo" <?php echo $status_filtro == 'inativo' ? 'selected' : ''; ?>>
                                    Inativo
                                </option>
                            </select>
                        </div>
                        
                        <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                        <div class="col-md-3">
                            <label for="clinica" class="form-label">Clínica</label>
                            <select class="form-select" id="clinica" name="clinica">
                                <option value="">Todas as clínicas</option>
                                <?php foreach ($clinicas as $clinica_item): ?>
                                    <option value="<?php echo $clinica_item['id_clinica']; ?>" 
                                            <?php echo $id_clinica_filtro == $clinica_item['id_clinica'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($clinica_item['nome_clinica']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-md-2">
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>
                                    Filtrar
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Lista de Usuários -->
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    Lista de Usuários (<?php echo count($usuarios); ?>)
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($usuarios)): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-users fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Nenhum usuário encontrado</h5>
                        <p class="text-muted">
                            <?php if (!empty($busca) || !empty($perfil_filtro) || !empty($status_filtro)): ?>
                                Tente ajustar os filtros de busca.
                            <?php else: ?>
                                Não há usuários cadastrados no sistema.
                            <?php endif; ?>
                        </p>
                        <?php if ($_SESSION['perfil_acesso'] === 'Administrador'): ?>
                            <a href="cadastrar.php" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>
                                Cadastrar Primeiro Usuário
                            </a>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Usuário</th>
                                    <th>Email</th>
                                    <th>Perfil</th>
                                    <th>Clínica</th>
                                    <th>Status</th>
                                    <th>Último Login</th>
                                    <th>Criado em</th>
                                    <th class="no-print">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($usuarios as $user): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-circle me-3">
                                                <?php echo strtoupper(substr($user['nome_usuario'], 0, 2)); ?>
                                            </div>
                                            <div>
                                                <strong><?php echo htmlspecialchars($user['nome_usuario']); ?></strong>
                                                <?php if ($user['id_usuario'] == $_SESSION['id_usuario']): ?>
                                                    <span class="badge bg-info ms-2">Você</span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="font-monospace"><?php echo htmlspecialchars($user['email']); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge perfil-<?php echo strtolower($user['perfil_acesso']); ?>">
                                            <?php echo $user['perfil_acesso']; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if (!empty($user['nome_clinica'])): ?>
                                            <small><?php echo htmlspecialchars($user['nome_clinica']); ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">Todas as clínicas</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($user['ativo']): ?>
                                            <span class="badge bg-success">Ativo</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Inativo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if (!empty($user['ultimo_login'])): ?>
                                            <small>
                                                <?php echo date('d/m/Y H:i', strtotime($user['ultimo_login'])); ?>
                                                <br><span class="text-muted">
                                                    <?php 
                                                    $dias_atras = floor((time() - strtotime($user['ultimo_login'])) / (60 * 60 * 24));
                                                    if ($dias_atras == 0) {
                                                        echo 'Hoje';
                                                    } elseif ($dias_atras == 1) {
                                                        echo 'Ontem';
                                                    } else {
                                                        echo $dias_atras . ' dias atrás';
                                                    }
                                                    ?>
                                                </span>
                                            </small>
                                        <?php else: ?>
                                            <span class="text-muted">Nunca logou</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <small><?php echo date('d/m/Y', strtotime($user['data_criacao'])); ?></small>
                                    </td>
                                    <td class="no-print">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="visualizar.php?id=<?php echo $user['id_usuario']; ?>" 
                                               class="btn btn-outline-info" title="Visualizar">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <?php if ($_SESSION['perfil_acesso'] === 'Administrador' || 
                                                      ($_SESSION['perfil_acesso'] === 'Gerente' && $user['perfil_acesso'] === 'Secretaria')): ?>
                                                <a href="editar.php?id=<?php echo $user['id_usuario']; ?>" 
                                                   class="btn btn-outline-warning" title="Editar">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                
                                                <?php if ($user['ativo']): ?>
                                                    <a href="alterar_status.php?id=<?php echo $user['id_usuario']; ?>&acao=desativar" 
                                                       class="btn btn-outline-danger" title="Desativar"
                                                       onclick="return confirm('Tem certeza que deseja desativar este usuário?')">
                                                        <i class="fas fa-user-slash"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="alterar_status.php?id=<?php echo $user['id_usuario']; ?>&acao=ativar" 
                                                       class="btn btn-outline-success" title="Ativar">
                                                        <i class="fas fa-user-check"></i>
                                                    </a>
                                                <?php endif; ?>
                                                
                                                <button type="button" class="btn btn-outline-secondary" 
                                                        onclick="resetarSenha(<?php echo $user['id_usuario']; ?>, '<?php echo htmlspecialchars($user['nome_usuario']); ?>')" 
                                                        title="Resetar Senha">
                                                    <i class="fas fa-key"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Resumo por Perfil -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <h6>Resumo por Perfil:</h6>
                            <div class="row">
                                <?php
                                $perfil_counts = [];
                                foreach ($usuarios as $user) {
                                    $perfil = $user['perfil_acesso'];
                                    $perfil_counts[$perfil] = ($perfil_counts[$perfil] ?? 0) + 1;
                                }
                                
                                $perfil_colors = [
                                    'Administrador' => 'warning',
                                    'Gerente' => 'info',
                                    'Secretaria' => 'secondary'
                                ];
                                
                                foreach ($perfil_counts as $perfil => $count):
                                    $color = $perfil_colors[$perfil] ?? 'primary';
                                ?>
                                <div class="col-md-4 mb-2">
                                    <div class="d-flex align-items-center">
                                        <span class="badge bg-<?php echo $color; ?> me-2"><?php echo $count; ?></span>
                                        <span><?php echo $perfil; ?><?php echo $count > 1 ? 's' : ''; ?></span>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Reset de Senha -->
<div class="modal fade" id="modalResetSenha" tabindex="-1" aria-labelledby="modalResetSenhaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalResetSenhaLabel">
                    <i class="fas fa-key me-2"></i>
                    Resetar Senha
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja resetar a senha do usuário <strong id="nomeUsuarioReset"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    Uma nova senha temporária será gerada e exibida para você. O usuário deverá alterar a senha no primeiro login.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-warning" id="btnConfirmarReset">
                    <i class="fas fa-key me-2"></i>
                    Resetar Senha
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Nova Senha -->
<div class="modal fade" id="modalNovaSenha" tabindex="-1" aria-labelledby="modalNovaSenhaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="modalNovaSenhaLabel">
                    <i class="fas fa-check-circle me-2"></i>
                    Senha Resetada com Sucesso
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>A senha foi resetada com sucesso!</p>
                <div class="alert alert-info">
                    <h6><i class="fas fa-key me-2"></i>Nova senha temporária:</h6>
                    <div class="input-group">
                        <input type="text" class="form-control font-monospace" id="novaSenhaGerada" readonly>
                        <button class="btn btn-outline-secondary" type="button" onclick="copiarSenha()">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                </div>
                <p class="text-muted">
                    <i class="fas fa-info-circle me-1"></i>
                    Anote esta senha e forneça ao usuário. Ele deverá alterar a senha no primeiro login.
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Entendi</button>
            </div>
        </div>
    </div>
</div>

<style>
.avatar-circle {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(45deg, #007bff, #0056b3);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 14px;
}

.perfil-administrador {
    background-color: #ffc107 !important;
    color: #000 !important;
}

.perfil-gerente {
    background-color: #17a2b8 !important;
}

.perfil-secretaria {
    background-color: #6c757d !important;
}

@media print {
    .no-print {
        display: none !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .card-header {
        background-color: #f8f9fa !important;
        color: #000 !important;
        border-bottom: 2px solid #000 !important;
    }
    
    .btn {
        display: none !important;
    }
    
    .navbar {
        display: none !important;
    }
    
    .container-fluid {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .table {
        font-size: 11px;
    }
    
    .badge {
        border: 1px solid #000 !important;
        color: #000 !important;
        background-color: transparent !important;
    }
}
</style>

<script>
let idUsuarioReset = null;

function resetarSenha(idUsuario, nomeUsuario) {
    idUsuarioReset = idUsuario;
    document.getElementById('nomeUsuarioReset').textContent = nomeUsuario;
    new bootstrap.Modal(document.getElementById('modalResetSenha')).show();
}

document.getElementById('btnConfirmarReset').addEventListener('click', function() {
    if (idUsuarioReset) {
        // Fazer requisição AJAX para resetar senha
        fetch('resetar_senha.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'id_usuario=' + idUsuarioReset
        })
        .then(response => response.json())
        .then(data => {
            if (data.sucesso) {
                document.getElementById('novaSenhaGerada').value = data.nova_senha;
                bootstrap.Modal.getInstance(document.getElementById('modalResetSenha')).hide();
                new bootstrap.Modal(document.getElementById('modalNovaSenha')).show();
            } else {
                mostrarToast('Erro', data.erro || 'Erro ao resetar senha', 'danger');
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            mostrarToast('Erro', 'Erro de comunicação com o servidor', 'danger');
        });
    }
});

function copiarSenha() {
    const senhaInput = document.getElementById('novaSenhaGerada');
    senhaInput.select();
    senhaInput.setSelectionRange(0, 99999); // Para dispositivos móveis
    
    try {
        document.execCommand('copy');
        mostrarToast('Sucesso', 'Senha copiada para a área de transferência!', 'success');
    } catch (err) {
        console.error('Erro ao copiar:', err);
        mostrarToast('Erro', 'Não foi possível copiar a senha', 'warning');
    }
}

// Limpar busca
document.getElementById('busca').addEventListener('input', function() {
    if (this.value === '') {
        // Opcional: submeter automaticamente quando limpar a busca
        // this.form.submit();
    }
});
</script>

<?php include '../../includes/footer.php'; ?>
