<?php
require_once '../../config/config.php';
require_once 'Usuario.php';

// Verificar se está logado
verificarLogin();

// Verificar se tem permissão (apenas Administrador e Gerente)
if (!in_array($_SESSION['perfil_acesso'], ['Administrador', 'Gerente'])) {
    http_response_code(403);
    echo json_encode(['sucesso' => false, 'erro' => 'Sem permissão para esta operação']);
    exit;
}

// Verificar se é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['sucesso' => false, 'erro' => 'Método não permitido']);
    exit;
}

$id_usuario = $_POST['id_usuario'] ?? null;

if (empty($id_usuario)) {
    echo json_encode(['sucesso' => false, 'erro' => 'ID do usuário não fornecido']);
    exit;
}

try {
    $usuario = new Usuario();
    $usuario->id_usuario = $id_usuario;
    
    // Verificar se o usuário existe
    $dados_usuario = $usuario->lerUm();
    if (!$dados_usuario) {
        echo json_encode(['sucesso' => false, 'erro' => 'Usuário não encontrado']);
        exit;
    }
    
    // Verificar permissões específicas
    if ($_SESSION['perfil_acesso'] === 'Gerente') {
        // Gerente só pode resetar senha de secretárias da sua clínica
        if ($dados_usuario['perfil_acesso'] !== 'Secretaria' || 
            $dados_usuario['id_clinica'] != $_SESSION['id_clinica']) {
            echo json_encode(['sucesso' => false, 'erro' => 'Sem permissão para resetar a senha deste usuário']);
            exit;
        }
    }
    
    // Resetar senha
    $nova_senha = $usuario->resetarSenha();
    
    if ($nova_senha) {
        echo json_encode([
            'sucesso' => true, 
            'nova_senha' => $nova_senha,
            'mensagem' => 'Senha resetada com sucesso'
        ]);
    } else {
        echo json_encode(['sucesso' => false, 'erro' => 'Erro ao resetar senha']);
    }
    
} catch (Exception $e) {
    error_log("Erro ao resetar senha: " . $e->getMessage());
    echo json_encode(['sucesso' => false, 'erro' => 'Erro interno do servidor']);
}
?>
